/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.DocumentationPartType;
import software.amazon.awssdk.services.apigateway.transform.DocumentationPartLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentationPartLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentationPartLocation> {
    private final String type;
    private final String path;
    private final String method;
    private final String statusCode;
    private final String name;

    private DocumentationPartLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.path = builder.path;
        this.method = builder.method;
        this.statusCode = builder.statusCode;
        this.name = builder.name;
    }

    public DocumentationPartType type() {
        return DocumentationPartType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentationPartLocation)) {
            return false;
        }
        DocumentationPartLocation other = (DocumentationPartLocation)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.method(), other.method()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"DocumentationPartLocation").add("Type", (Object)this.typeAsString()).add("Path", (Object)this.path()).add("Method", (Object)this.method()).add("StatusCode", (Object)this.statusCode()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentationPartLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String path;
        private String method;
        private String statusCode;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentationPartLocation model) {
            this.type(model.type);
            this.path(model.path);
            this.method(model.method);
            this.statusCode(model.statusCode);
            this.name(model.name);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentationPartType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getMethod() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public DocumentationPartLocation build() {
            return new DocumentationPartLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentationPartLocation> {
        public Builder type(String var1);

        public Builder type(DocumentationPartType var1);

        public Builder path(String var1);

        public Builder method(String var1);

        public Builder statusCode(String var1);

        public Builder name(String var1);
    }
}

