/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcLinkRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateVpcLinkRequest> {
    private final String name;
    private final String description;
    private final List<String> targetArns;

    private CreateVpcLinkRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.targetArns = builder.targetArns;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<String> targetArns() {
        return this.targetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcLinkRequest)) {
            return false;
        }
        CreateVpcLinkRequest other = (CreateVpcLinkRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targetArns(), other.targetArns());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcLinkRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TargetArns", this.targetArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targetArns": {
                return Optional.ofNullable(clazz.cast(this.targetArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> targetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcLinkRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.targetArns(model.targetArns);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getTargetArns() {
            return this.targetArns;
        }

        @Override
        public final Builder targetArns(Collection<String> targetArns) {
            this.targetArns = ListOfStringCopier.copy(targetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetArns(String ... targetArns) {
            this.targetArns(Arrays.asList(targetArns));
            return this;
        }

        public final void setTargetArns(Collection<String> targetArns) {
            this.targetArns = ListOfStringCopier.copy(targetArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcLinkRequest build() {
            return new CreateVpcLinkRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateVpcLinkRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder targetArns(Collection<String> var1);

        public Builder targetArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

