/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.AccessLogSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessLogSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AccessLogSettings> {
    private final String format;
    private final String destinationArn;

    private AccessLogSettings(BuilderImpl builder) {
        this.format = builder.format;
        this.destinationArn = builder.destinationArn;
    }

    public String format() {
        return this.format;
    }

    public String destinationArn() {
        return this.destinationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLogSettings)) {
            return false;
        }
        AccessLogSettings other = (AccessLogSettings)obj;
        return Objects.equals(this.format(), other.format()) && Objects.equals(this.destinationArn(), other.destinationArn());
    }

    public String toString() {
        return ToString.builder((String)"AccessLogSettings").add("Format", (Object)this.format()).add("DestinationArn", (Object)this.destinationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessLogSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String destinationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLogSettings model) {
            this.format(model.format);
            this.destinationArn(model.destinationArn);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public AccessLogSettings build() {
            return new AccessLogSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessLogSettings> {
        public Builder format(String var1);

        public Builder destinationArn(String var1);
    }
}

