/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class RepeatableInputStreamRequestEntity
extends HttpEntityWrapper {
    private static final Logger log = Logger.loggerFor(RepeatableInputStreamRequestEntity.class);
    private boolean firstAttempt = true;
    private final boolean isChunked;
    private final InputStream content;
    private IOException originalException;

    public RepeatableInputStreamRequestEntity(HttpExecuteRequest request) {
        this(RepeatableInputStreamRequestEntity.createInputStreamEntityWithMetadata(request), request);
    }

    private RepeatableInputStreamRequestEntity(EntityCreationResult result, HttpExecuteRequest request) {
        super((HttpEntity)result.entity);
        this.content = result.content;
        this.isChunked = request.httpRequest().matchingHeaders("Transfer-Encoding").contains("chunked");
    }

    private static EntityCreationResult createInputStreamEntityWithMetadata(HttpExecuteRequest request) {
        InputStream content = RepeatableInputStreamRequestEntity.getContent(request.contentStreamProvider());
        long contentLength = request.httpRequest().firstMatchingHeader("Content-Length").map(RepeatableInputStreamRequestEntity::parseContentLength).orElse(-1L);
        ContentType contentType = request.httpRequest().firstMatchingHeader("Content-Type").map(RepeatableInputStreamRequestEntity::parseContentType).orElse(null);
        InputStreamEntity entity = contentLength >= 0L ? new InputStreamEntity(content, contentLength, contentType) : new InputStreamEntity(content, contentType);
        return new EntityCreationResult(entity, content);
    }

    private static long parseContentLength(String contentLength) {
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException nfe) {
            log.warn(() -> "Unable to parse content length from request. Buffering contents in memory.");
            return -1L;
        }
    }

    private static ContentType parseContentType(String contentTypeValue) {
        if (contentTypeValue == null) {
            return null;
        }
        try {
            return ContentType.parse((CharSequence)contentTypeValue);
        }
        catch (Exception e) {
            log.warn(() -> "Unable to parse content type: " + contentTypeValue);
            return null;
        }
    }

    private static InputStream getContent(Optional<ContentStreamProvider> contentStreamProvider) {
        return contentStreamProvider.map(ContentStreamProvider::newStream).orElseGet(() -> new ByteArrayInputStream(new byte[0]));
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || super.isRepeatable();
    }

    public void writeTo(OutputStream output) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            super.writeTo(output);
        }
        catch (IOException ioe) {
            if (this.originalException == null) {
                this.originalException = ioe;
            }
            throw this.originalException;
        }
    }

    public void close() throws IOException {
        super.close();
    }

    private static class EntityCreationResult {
        final InputStreamEntity entity;
        final InputStream content;

        EntityCreationResult(InputStreamEntity entity, InputStream content) {
            this.entity = entity;
            this.content = content;
        }
    }
}

