/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.conn;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache5.internal.net.SdkSslSocket;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class SdkTlsSocketFactory
extends DefaultClientTlsStrategy {
    private static final Logger log = Logger.loggerFor(SdkTlsSocketFactory.class);

    public SdkTlsSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
    }

    protected void initializeSocket(SSLSocket socket) {
        super.initializeSocket(socket);
        log.debug(() -> String.format("socket.getSupportedProtocols(): %s, socket.getEnabledProtocols(): %s", Arrays.toString(socket.getSupportedProtocols()), Arrays.toString(socket.getEnabledProtocols())));
    }

    public SSLSocket upgrade(Socket socket, String target, int port, Object attachment, HttpContext context) throws IOException {
        log.trace(() -> String.format("Upgrading socket to TLS for %s:%s", target, port));
        SSLSocket upgradedSocket = super.upgrade(socket, target, port, attachment, context);
        return new SdkSslSocket(upgradedSocket);
    }
}

