/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache5.ProxyConfiguration;

@SdkInternalApi
public final class Apache5HttpRequestConfig {
    private final Duration socketTimeout;
    private final Duration connectionAcquireTimeout;
    private final boolean expectContinueEnabled;
    private final ProxyConfiguration proxyConfiguration;

    private Apache5HttpRequestConfig(Builder builder) {
        this.socketTimeout = builder.socketTimeout;
        this.connectionAcquireTimeout = builder.connectionAcquireTimeout;
        this.expectContinueEnabled = builder.expectContinueEnabled;
        this.proxyConfiguration = builder.proxyConfiguration;
    }

    public Duration socketTimeout() {
        return this.socketTimeout;
    }

    public Duration connectionAcquireTimeout() {
        return this.connectionAcquireTimeout;
    }

    public boolean expectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    public ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration socketTimeout;
        private Duration connectionAcquireTimeout;
        private boolean expectContinueEnabled;
        private ProxyConfiguration proxyConfiguration;

        private Builder() {
        }

        public Builder socketTimeout(Duration socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectionAcquireTimeout(Duration connectionAcquireTimeout) {
            this.connectionAcquireTimeout = connectionAcquireTimeout;
            return this;
        }

        public Builder expectContinueEnabled(boolean expectContinueEnabled) {
            this.expectContinueEnabled = expectContinueEnabled;
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public Apache5HttpRequestConfig build() {
            return new Apache5HttpRequestConfig(this);
        }
    }
}

