/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal;

import java.util.Set;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private Set<String> hostPatterns;

    public SdkProxyRoutePlanner(String proxyHost, int proxyPort, String proxyProtocol, Set<String> nonProxyHosts) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(proxyProtocol, proxyHost, proxyPort);
        this.hostPatterns = nonProxyHosts;
    }

    private boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.hostPatterns == null) {
            return false;
        }
        String targetHost = StringUtils.lowerCase((String)target.getHostName());
        for (String pattern : this.hostPatterns) {
            if (!targetHost.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

