/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@ReviewBeforeRelease(value="Review which options are required and which are optional.")
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final URI endpoint;
    private final String username;
    private final String password;
    private final String ntlmDomain;
    private final String ntlmWorkstation;
    private final Set<String> nonProxyHosts;
    private final Boolean preemptiveBasicAuthenticationEnabled;

    private ProxyConfiguration(DefaultClientProxyConfigurationBuilder builder) {
        this.endpoint = builder.endpoint;
        this.username = builder.username;
        this.password = builder.password;
        this.ntlmDomain = builder.ntlmDomain;
        this.ntlmWorkstation = builder.ntlmWorkstation;
        this.nonProxyHosts = Collections.unmodifiableSet(new HashSet(builder.nonProxyHosts));
        this.preemptiveBasicAuthenticationEnabled = builder.preemptiveBasicAuthenticationEnabled == null ? Boolean.FALSE : builder.preemptiveBasicAuthenticationEnabled;
    }

    public URI endpoint() {
        return this.endpoint;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String ntlmDomain() {
        return this.ntlmDomain;
    }

    public String ntlmWorkstation() {
        return this.ntlmWorkstation;
    }

    @ReviewBeforeRelease(value="Revisit the presentation of this option and support http.nonProxyHosts property")
    public Set<String> nonProxyHosts() {
        return this.nonProxyHosts;
    }

    public Boolean preemptiveBasicAuthenticationEnabled() {
        return this.preemptiveBasicAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return ProxyConfiguration.builder().endpoint(this.endpoint).username(this.username).password(this.password).ntlmDomain(this.ntlmDomain).ntlmWorkstation(this.ntlmWorkstation).nonProxyHosts(this.nonProxyHosts).preemptiveBasicAuthenticationEnabled(this.preemptiveBasicAuthenticationEnabled);
    }

    public static Builder builder() {
        return new DefaultClientProxyConfigurationBuilder();
    }

    public String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("endpoint", (Object)this.endpoint).add("username", (Object)this.username).add("password", (Object)this.password).add("ntlmDomain", (Object)this.ntlmDomain).add("ntlmWorkstation", (Object)this.ntlmWorkstation).add("nonProxyHosts", this.nonProxyHosts).add("preemptiveBasicAuthenticationEnabled", (Object)this.preemptiveBasicAuthenticationEnabled).build();
    }

    private static final class DefaultClientProxyConfigurationBuilder
    implements Builder {
        private URI endpoint;
        private String username;
        private String password;
        private String ntlmDomain;
        private String ntlmWorkstation;
        private Set<String> nonProxyHosts = new HashSet<String>();
        private Boolean preemptiveBasicAuthenticationEnabled;

        private DefaultClientProxyConfigurationBuilder() {
        }

        @Override
        public Builder endpoint(URI endpoint) {
            if (endpoint != null) {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getUserInfo()), (String)"Proxy endpoint user info is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getPath()), (String)"Proxy endpoint path is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getQuery()), (String)"Proxy endpoint query is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getFragment()), (String)"Proxy endpoint fragment is not supported.", (Object[])new Object[0]);
            }
            this.endpoint = endpoint;
            return this;
        }

        public void setEndpoint(URI endpoint) {
            this.endpoint(endpoint);
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public void setUsername(String username) {
            this.username(username);
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public void setPassword(String password) {
            this.password(password);
        }

        @Override
        public Builder ntlmDomain(String proxyDomain) {
            this.ntlmDomain = proxyDomain;
            return this;
        }

        public void setNtlmDomain(String ntlmDomain) {
            this.ntlmDomain(ntlmDomain);
        }

        @Override
        public Builder ntlmWorkstation(String proxyWorkstation) {
            this.ntlmWorkstation = proxyWorkstation;
            return this;
        }

        public void setNtlmWorkstation(String ntlmWorkstation) {
            this.ntlmWorkstation(ntlmWorkstation);
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = new HashSet<String>(nonProxyHosts);
            return this;
        }

        @Override
        public Builder addNonProxyHost(String nonProxyHost) {
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public void setNonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts(nonProxyHosts);
        }

        @Override
        public Builder preemptiveBasicAuthenticationEnabled(Boolean preemptiveBasicAuthenticationEnabled) {
            this.preemptiveBasicAuthenticationEnabled = preemptiveBasicAuthenticationEnabled;
            return this;
        }

        public void setPreemptiveBasicAuthenticationEnabled(Boolean preemptiveBasicAuthenticationEnabled) {
            this.preemptiveBasicAuthenticationEnabled(preemptiveBasicAuthenticationEnabled);
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder endpoint(URI var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder ntlmDomain(String var1);

        public Builder ntlmWorkstation(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder addNonProxyHost(String var1);

        public Builder preemptiveBasicAuthenticationEnabled(Boolean var1);
    }
}

