/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.impl.ApacheHttpRequestFactory;
import software.amazon.awssdk.http.apache.internal.impl.ConnectionManagerAwareHttpClient;
import software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class ApacheHttpClient
implements SdkHttpClient {
    private final ApacheHttpRequestFactory apacheHttpRequestFactory = new ApacheHttpRequestFactory();
    private final ConnectionManagerAwareHttpClient httpClient;
    private final ApacheHttpRequestConfig requestConfig;
    private final AttributeMap resolvedOptions;

    ApacheHttpClient(ConnectionManagerAwareHttpClient httpClient, ApacheHttpRequestConfig requestConfig, AttributeMap resolvedOptions) {
        this.httpClient = (ConnectionManagerAwareHttpClient)Validate.notNull((Object)httpClient, (String)"httpClient must not be null.", (Object[])new Object[0]);
        this.requestConfig = (ApacheHttpRequestConfig)Validate.notNull((Object)requestConfig, (String)"requestConfig must not be null.", (Object[])new Object[0]);
        this.resolvedOptions = (AttributeMap)Validate.notNull((Object)resolvedOptions, (String)"resolvedOptions must not be null", (Object[])new Object[0]);
    }

    public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext context) {
        final HttpRequestBase apacheRequest = this.toApacheRequest(request);
        return new AbortableCallable<SdkHttpFullResponse>(){

            public SdkHttpFullResponse call() throws Exception {
                return ApacheHttpClient.this.execute(apacheRequest);
            }

            public void abort() {
                apacheRequest.abort();
            }
        };
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.ofNullable(this.resolvedOptions.get(key));
    }

    public void close() {
        this.httpClient.getHttpClientConnectionManager().shutdown();
    }

    private SdkHttpFullResponse execute(HttpRequestBase apacheRequest) throws IOException {
        HttpClientContext localRequestContext = ApacheUtils.newClientContext(this.requestConfig.proxyConfiguration());
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)apacheRequest, (HttpContext)localRequestContext);
        return this.createResponse(httpResponse, apacheRequest);
    }

    private HttpRequestBase toApacheRequest(SdkHttpFullRequest request) {
        return this.apacheHttpRequestFactory.create(request, this.requestConfig);
    }

    private SdkHttpFullResponse createResponse(HttpResponse apacheHttpResponse, HttpRequestBase apacheRequest) throws IOException {
        return (SdkHttpFullResponse)SdkHttpFullResponse.builder().statusCode(apacheHttpResponse.getStatusLine().getStatusCode()).statusText(apacheHttpResponse.getStatusLine().getReasonPhrase()).content(apacheHttpResponse.getEntity() != null ? this.toAbortableInputStream(apacheHttpResponse, apacheRequest) : null).headers(this.transformHeaders(apacheHttpResponse)).build();
    }

    private AbortableInputStream toAbortableInputStream(HttpResponse apacheHttpResponse, HttpRequestBase apacheRequest) throws IOException {
        return new AbortableInputStream(apacheHttpResponse.getEntity().getContent(), () -> ((HttpRequestBase)apacheRequest).abort());
    }

    private Map<String, List<String>> transformHeaders(HttpResponse apacheHttpResponse) {
        return Stream.of(apacheHttpResponse.getAllHeaders()).collect(Collectors.groupingBy(Header::getName, Collectors.mapping(Header::getValue, Collectors.toList())));
    }
}

