/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody;
import software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExchangeCodeForTokenRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, ExchangeCodeForTokenRequest> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(ExchangeCodeForTokenRequest.getter(ExchangeCodeForTokenRequest::providerAsString)).setter(ExchangeCodeForTokenRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("provider").build()}).build();
    private static final SdkField<ExchangeCodeForTokenRequestBody> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(ExchangeCodeForTokenRequest.getter(ExchangeCodeForTokenRequest::request)).setter(ExchangeCodeForTokenRequest.setter(Builder::request)).constructor(ExchangeCodeForTokenRequestBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExchangeCodeForTokenRequest.memberNameToFieldInitializer();
    private final String provider;
    private final ExchangeCodeForTokenRequestBody request;

    private ExchangeCodeForTokenRequest(BuilderImpl builder) {
        super(builder);
        this.provider = builder.provider;
        this.request = builder.request;
    }

    public final TokenProviders provider() {
        return TokenProviders.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final ExchangeCodeForTokenRequestBody request() {
        return this.request;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExchangeCodeForTokenRequest)) {
            return false;
        }
        ExchangeCodeForTokenRequest other = (ExchangeCodeForTokenRequest)((Object)obj);
        return Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.request(), other.request());
    }

    public final String toString() {
        return ToString.builder((String)"ExchangeCodeForTokenRequest").add("Provider", (Object)this.providerAsString()).add("Request", (Object)this.request()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("provider", PROVIDER_FIELD);
        map.put("request", REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExchangeCodeForTokenRequest, T> g) {
        return obj -> g.apply((ExchangeCodeForTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String provider;
        private ExchangeCodeForTokenRequestBody request;

        private BuilderImpl() {
        }

        private BuilderImpl(ExchangeCodeForTokenRequest model) {
            super(model);
            this.provider(model.provider);
            this.request(model.request);
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(TokenProviders provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final ExchangeCodeForTokenRequestBody.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(ExchangeCodeForTokenRequestBody.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(ExchangeCodeForTokenRequestBody request) {
            this.request = request;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExchangeCodeForTokenRequest build() {
            return new ExchangeCodeForTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExchangeCodeForTokenRequest> {
        public Builder provider(String var1);

        public Builder provider(TokenProviders var1);

        public Builder request(ExchangeCodeForTokenRequestBody var1);

        default public Builder request(Consumer<ExchangeCodeForTokenRequestBody.Builder> request) {
            return this.request((ExchangeCodeForTokenRequestBody)((ExchangeCodeForTokenRequestBody.Builder)ExchangeCodeForTokenRequestBody.builder().applyMutation(request)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

