/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.AssociatedFieldsListCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.GenericDataRelationshipType;
import software.amazon.awssdk.services.amplifyuibuilder.model.RelatedModelFieldsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodegenGenericDataRelationshipType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodegenGenericDataRelationshipType> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::typeAsString)).setter(CodegenGenericDataRelationshipType.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> RELATED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedModelName").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::relatedModelName)).setter(CodegenGenericDataRelationshipType.setter(Builder::relatedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedModelName").build()}).build();
    private static final SdkField<List<String>> RELATED_MODEL_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedModelFields").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::relatedModelFields)).setter(CodegenGenericDataRelationshipType.setter(Builder::relatedModelFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedModelFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CAN_UNLINK_ASSOCIATED_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canUnlinkAssociatedModel").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::canUnlinkAssociatedModel)).setter(CodegenGenericDataRelationshipType.setter(Builder::canUnlinkAssociatedModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUnlinkAssociatedModel").build()}).build();
    private static final SdkField<String> RELATED_JOIN_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedJoinFieldName").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::relatedJoinFieldName)).setter(CodegenGenericDataRelationshipType.setter(Builder::relatedJoinFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedJoinFieldName").build()}).build();
    private static final SdkField<String> RELATED_JOIN_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedJoinTableName").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::relatedJoinTableName)).setter(CodegenGenericDataRelationshipType.setter(Builder::relatedJoinTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedJoinTableName").build()}).build();
    private static final SdkField<String> BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("belongsToFieldOnRelatedModel").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::belongsToFieldOnRelatedModel)).setter(CodegenGenericDataRelationshipType.setter(Builder::belongsToFieldOnRelatedModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("belongsToFieldOnRelatedModel").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedFields").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::associatedFields)).setter(CodegenGenericDataRelationshipType.setter(Builder::associatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_HAS_MANY_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isHasManyIndex").getter(CodegenGenericDataRelationshipType.getter(CodegenGenericDataRelationshipType::isHasManyIndex)).setter(CodegenGenericDataRelationshipType.setter(Builder::isHasManyIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isHasManyIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RELATED_MODEL_NAME_FIELD, RELATED_MODEL_FIELDS_FIELD, CAN_UNLINK_ASSOCIATED_MODEL_FIELD, RELATED_JOIN_FIELD_NAME_FIELD, RELATED_JOIN_TABLE_NAME_FIELD, BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD, ASSOCIATED_FIELDS_FIELD, IS_HAS_MANY_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodegenGenericDataRelationshipType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String relatedModelName;
    private final List<String> relatedModelFields;
    private final Boolean canUnlinkAssociatedModel;
    private final String relatedJoinFieldName;
    private final String relatedJoinTableName;
    private final String belongsToFieldOnRelatedModel;
    private final List<String> associatedFields;
    private final Boolean isHasManyIndex;

    private CodegenGenericDataRelationshipType(BuilderImpl builder) {
        this.type = builder.type;
        this.relatedModelName = builder.relatedModelName;
        this.relatedModelFields = builder.relatedModelFields;
        this.canUnlinkAssociatedModel = builder.canUnlinkAssociatedModel;
        this.relatedJoinFieldName = builder.relatedJoinFieldName;
        this.relatedJoinTableName = builder.relatedJoinTableName;
        this.belongsToFieldOnRelatedModel = builder.belongsToFieldOnRelatedModel;
        this.associatedFields = builder.associatedFields;
        this.isHasManyIndex = builder.isHasManyIndex;
    }

    public final GenericDataRelationshipType type() {
        return GenericDataRelationshipType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String relatedModelName() {
        return this.relatedModelName;
    }

    public final boolean hasRelatedModelFields() {
        return this.relatedModelFields != null && !(this.relatedModelFields instanceof SdkAutoConstructList);
    }

    public final List<String> relatedModelFields() {
        return this.relatedModelFields;
    }

    public final Boolean canUnlinkAssociatedModel() {
        return this.canUnlinkAssociatedModel;
    }

    public final String relatedJoinFieldName() {
        return this.relatedJoinFieldName;
    }

    public final String relatedJoinTableName() {
        return this.relatedJoinTableName;
    }

    public final String belongsToFieldOnRelatedModel() {
        return this.belongsToFieldOnRelatedModel;
    }

    public final boolean hasAssociatedFields() {
        return this.associatedFields != null && !(this.associatedFields instanceof SdkAutoConstructList);
    }

    public final List<String> associatedFields() {
        return this.associatedFields;
    }

    public final Boolean isHasManyIndex() {
        return this.isHasManyIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedModelFields() ? this.relatedModelFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canUnlinkAssociatedModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedJoinFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedJoinTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.belongsToFieldOnRelatedModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedFields() ? this.associatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isHasManyIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenGenericDataRelationshipType)) {
            return false;
        }
        CodegenGenericDataRelationshipType other = (CodegenGenericDataRelationshipType)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.relatedModelName(), other.relatedModelName()) && this.hasRelatedModelFields() == other.hasRelatedModelFields() && Objects.equals(this.relatedModelFields(), other.relatedModelFields()) && Objects.equals(this.canUnlinkAssociatedModel(), other.canUnlinkAssociatedModel()) && Objects.equals(this.relatedJoinFieldName(), other.relatedJoinFieldName()) && Objects.equals(this.relatedJoinTableName(), other.relatedJoinTableName()) && Objects.equals(this.belongsToFieldOnRelatedModel(), other.belongsToFieldOnRelatedModel()) && this.hasAssociatedFields() == other.hasAssociatedFields() && Objects.equals(this.associatedFields(), other.associatedFields()) && Objects.equals(this.isHasManyIndex(), other.isHasManyIndex());
    }

    public final String toString() {
        return ToString.builder((String)"CodegenGenericDataRelationshipType").add("Type", (Object)this.typeAsString()).add("RelatedModelName", (Object)this.relatedModelName()).add("RelatedModelFields", this.hasRelatedModelFields() ? this.relatedModelFields() : null).add("CanUnlinkAssociatedModel", (Object)this.canUnlinkAssociatedModel()).add("RelatedJoinFieldName", (Object)this.relatedJoinFieldName()).add("RelatedJoinTableName", (Object)this.relatedJoinTableName()).add("BelongsToFieldOnRelatedModel", (Object)this.belongsToFieldOnRelatedModel()).add("AssociatedFields", this.hasAssociatedFields() ? this.associatedFields() : null).add("IsHasManyIndex", (Object)this.isHasManyIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "relatedModelName": {
                return Optional.ofNullable(clazz.cast(this.relatedModelName()));
            }
            case "relatedModelFields": {
                return Optional.ofNullable(clazz.cast(this.relatedModelFields()));
            }
            case "canUnlinkAssociatedModel": {
                return Optional.ofNullable(clazz.cast(this.canUnlinkAssociatedModel()));
            }
            case "relatedJoinFieldName": {
                return Optional.ofNullable(clazz.cast(this.relatedJoinFieldName()));
            }
            case "relatedJoinTableName": {
                return Optional.ofNullable(clazz.cast(this.relatedJoinTableName()));
            }
            case "belongsToFieldOnRelatedModel": {
                return Optional.ofNullable(clazz.cast(this.belongsToFieldOnRelatedModel()));
            }
            case "associatedFields": {
                return Optional.ofNullable(clazz.cast(this.associatedFields()));
            }
            case "isHasManyIndex": {
                return Optional.ofNullable(clazz.cast(this.isHasManyIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("relatedModelName", RELATED_MODEL_NAME_FIELD);
        map.put("relatedModelFields", RELATED_MODEL_FIELDS_FIELD);
        map.put("canUnlinkAssociatedModel", CAN_UNLINK_ASSOCIATED_MODEL_FIELD);
        map.put("relatedJoinFieldName", RELATED_JOIN_FIELD_NAME_FIELD);
        map.put("relatedJoinTableName", RELATED_JOIN_TABLE_NAME_FIELD);
        map.put("belongsToFieldOnRelatedModel", BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD);
        map.put("associatedFields", ASSOCIATED_FIELDS_FIELD);
        map.put("isHasManyIndex", IS_HAS_MANY_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenGenericDataRelationshipType, T> g) {
        return obj -> g.apply((CodegenGenericDataRelationshipType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String relatedModelName;
        private List<String> relatedModelFields = DefaultSdkAutoConstructList.getInstance();
        private Boolean canUnlinkAssociatedModel;
        private String relatedJoinFieldName;
        private String relatedJoinTableName;
        private String belongsToFieldOnRelatedModel;
        private List<String> associatedFields = DefaultSdkAutoConstructList.getInstance();
        private Boolean isHasManyIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenGenericDataRelationshipType model) {
            this.type(model.type);
            this.relatedModelName(model.relatedModelName);
            this.relatedModelFields(model.relatedModelFields);
            this.canUnlinkAssociatedModel(model.canUnlinkAssociatedModel);
            this.relatedJoinFieldName(model.relatedJoinFieldName);
            this.relatedJoinTableName(model.relatedJoinTableName);
            this.belongsToFieldOnRelatedModel(model.belongsToFieldOnRelatedModel);
            this.associatedFields(model.associatedFields);
            this.isHasManyIndex(model.isHasManyIndex);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GenericDataRelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRelatedModelName() {
            return this.relatedModelName;
        }

        public final void setRelatedModelName(String relatedModelName) {
            this.relatedModelName = relatedModelName;
        }

        @Override
        public final Builder relatedModelName(String relatedModelName) {
            this.relatedModelName = relatedModelName;
            return this;
        }

        public final Collection<String> getRelatedModelFields() {
            if (this.relatedModelFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedModelFields;
        }

        public final void setRelatedModelFields(Collection<String> relatedModelFields) {
            this.relatedModelFields = RelatedModelFieldsListCopier.copy(relatedModelFields);
        }

        @Override
        public final Builder relatedModelFields(Collection<String> relatedModelFields) {
            this.relatedModelFields = RelatedModelFieldsListCopier.copy(relatedModelFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedModelFields(String ... relatedModelFields) {
            this.relatedModelFields(Arrays.asList(relatedModelFields));
            return this;
        }

        public final Boolean getCanUnlinkAssociatedModel() {
            return this.canUnlinkAssociatedModel;
        }

        public final void setCanUnlinkAssociatedModel(Boolean canUnlinkAssociatedModel) {
            this.canUnlinkAssociatedModel = canUnlinkAssociatedModel;
        }

        @Override
        public final Builder canUnlinkAssociatedModel(Boolean canUnlinkAssociatedModel) {
            this.canUnlinkAssociatedModel = canUnlinkAssociatedModel;
            return this;
        }

        public final String getRelatedJoinFieldName() {
            return this.relatedJoinFieldName;
        }

        public final void setRelatedJoinFieldName(String relatedJoinFieldName) {
            this.relatedJoinFieldName = relatedJoinFieldName;
        }

        @Override
        public final Builder relatedJoinFieldName(String relatedJoinFieldName) {
            this.relatedJoinFieldName = relatedJoinFieldName;
            return this;
        }

        public final String getRelatedJoinTableName() {
            return this.relatedJoinTableName;
        }

        public final void setRelatedJoinTableName(String relatedJoinTableName) {
            this.relatedJoinTableName = relatedJoinTableName;
        }

        @Override
        public final Builder relatedJoinTableName(String relatedJoinTableName) {
            this.relatedJoinTableName = relatedJoinTableName;
            return this;
        }

        public final String getBelongsToFieldOnRelatedModel() {
            return this.belongsToFieldOnRelatedModel;
        }

        public final void setBelongsToFieldOnRelatedModel(String belongsToFieldOnRelatedModel) {
            this.belongsToFieldOnRelatedModel = belongsToFieldOnRelatedModel;
        }

        @Override
        public final Builder belongsToFieldOnRelatedModel(String belongsToFieldOnRelatedModel) {
            this.belongsToFieldOnRelatedModel = belongsToFieldOnRelatedModel;
            return this;
        }

        public final Collection<String> getAssociatedFields() {
            if (this.associatedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedFields;
        }

        public final void setAssociatedFields(Collection<String> associatedFields) {
            this.associatedFields = AssociatedFieldsListCopier.copy(associatedFields);
        }

        @Override
        public final Builder associatedFields(Collection<String> associatedFields) {
            this.associatedFields = AssociatedFieldsListCopier.copy(associatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFields(String ... associatedFields) {
            this.associatedFields(Arrays.asList(associatedFields));
            return this;
        }

        public final Boolean getIsHasManyIndex() {
            return this.isHasManyIndex;
        }

        public final void setIsHasManyIndex(Boolean isHasManyIndex) {
            this.isHasManyIndex = isHasManyIndex;
        }

        @Override
        public final Builder isHasManyIndex(Boolean isHasManyIndex) {
            this.isHasManyIndex = isHasManyIndex;
            return this;
        }

        public CodegenGenericDataRelationshipType build() {
            return new CodegenGenericDataRelationshipType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodegenGenericDataRelationshipType> {
        public Builder type(String var1);

        public Builder type(GenericDataRelationshipType var1);

        public Builder relatedModelName(String var1);

        public Builder relatedModelFields(Collection<String> var1);

        public Builder relatedModelFields(String ... var1);

        public Builder canUnlinkAssociatedModel(Boolean var1);

        public Builder relatedJoinFieldName(String var1);

        public Builder relatedJoinTableName(String var1);

        public Builder belongsToFieldOnRelatedModel(String var1);

        public Builder associatedFields(Collection<String> var1);

        public Builder associatedFields(String ... var1);

        public Builder isHasManyIndex(Boolean var1);
    }
}

