/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel;
import software.amazon.awssdk.services.amplifyuibuilder.model.StrValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileUploaderFieldConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileUploaderFieldConfig> {
    private static final SdkField<String> ACCESS_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessLevel").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::accessLevelAsString)).setter(FileUploaderFieldConfig.setter(Builder::accessLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLevel").build()}).build();
    private static final SdkField<List<String>> ACCEPTED_FILE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceptedFileTypes").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::acceptedFileTypes)).setter(FileUploaderFieldConfig.setter(Builder::acceptedFileTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedFileTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SHOW_THUMBNAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("showThumbnails").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::showThumbnails)).setter(FileUploaderFieldConfig.setter(Builder::showThumbnails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("showThumbnails").build()}).build();
    private static final SdkField<Boolean> IS_RESUMABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isResumable").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::isResumable)).setter(FileUploaderFieldConfig.setter(Builder::isResumable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResumable").build()}).build();
    private static final SdkField<Integer> MAX_FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFileCount").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::maxFileCount)).setter(FileUploaderFieldConfig.setter(Builder::maxFileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFileCount").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSize").getter(FileUploaderFieldConfig.getter(FileUploaderFieldConfig::maxSize)).setter(FileUploaderFieldConfig.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LEVEL_FIELD, ACCEPTED_FILE_TYPES_FIELD, SHOW_THUMBNAILS_FIELD, IS_RESUMABLE_FIELD, MAX_FILE_COUNT_FIELD, MAX_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessLevel", ACCESS_LEVEL_FIELD);
            this.put("acceptedFileTypes", ACCEPTED_FILE_TYPES_FIELD);
            this.put("showThumbnails", SHOW_THUMBNAILS_FIELD);
            this.put("isResumable", IS_RESUMABLE_FIELD);
            this.put("maxFileCount", MAX_FILE_COUNT_FIELD);
            this.put("maxSize", MAX_SIZE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accessLevel;
    private final List<String> acceptedFileTypes;
    private final Boolean showThumbnails;
    private final Boolean isResumable;
    private final Integer maxFileCount;
    private final Integer maxSize;

    private FileUploaderFieldConfig(BuilderImpl builder) {
        this.accessLevel = builder.accessLevel;
        this.acceptedFileTypes = builder.acceptedFileTypes;
        this.showThumbnails = builder.showThumbnails;
        this.isResumable = builder.isResumable;
        this.maxFileCount = builder.maxFileCount;
        this.maxSize = builder.maxSize;
    }

    public final StorageAccessLevel accessLevel() {
        return StorageAccessLevel.fromValue(this.accessLevel);
    }

    public final String accessLevelAsString() {
        return this.accessLevel;
    }

    public final boolean hasAcceptedFileTypes() {
        return this.acceptedFileTypes != null && !(this.acceptedFileTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceptedFileTypes() {
        return this.acceptedFileTypes;
    }

    public final Boolean showThumbnails() {
        return this.showThumbnails;
    }

    public final Boolean isResumable() {
        return this.isResumable;
    }

    public final Integer maxFileCount() {
        return this.maxFileCount;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceptedFileTypes() ? this.acceptedFileTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.showThumbnails());
        hashCode = 31 * hashCode + Objects.hashCode(this.isResumable());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploaderFieldConfig)) {
            return false;
        }
        FileUploaderFieldConfig other = (FileUploaderFieldConfig)obj;
        return Objects.equals(this.accessLevelAsString(), other.accessLevelAsString()) && this.hasAcceptedFileTypes() == other.hasAcceptedFileTypes() && Objects.equals(this.acceptedFileTypes(), other.acceptedFileTypes()) && Objects.equals(this.showThumbnails(), other.showThumbnails()) && Objects.equals(this.isResumable(), other.isResumable()) && Objects.equals(this.maxFileCount(), other.maxFileCount()) && Objects.equals(this.maxSize(), other.maxSize());
    }

    public final String toString() {
        return ToString.builder((String)"FileUploaderFieldConfig").add("AccessLevel", (Object)this.accessLevelAsString()).add("AcceptedFileTypes", this.hasAcceptedFileTypes() ? this.acceptedFileTypes() : null).add("ShowThumbnails", (Object)this.showThumbnails()).add("IsResumable", (Object)this.isResumable()).add("MaxFileCount", (Object)this.maxFileCount()).add("MaxSize", (Object)this.maxSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessLevel": {
                return Optional.ofNullable(clazz.cast(this.accessLevelAsString()));
            }
            case "acceptedFileTypes": {
                return Optional.ofNullable(clazz.cast(this.acceptedFileTypes()));
            }
            case "showThumbnails": {
                return Optional.ofNullable(clazz.cast(this.showThumbnails()));
            }
            case "isResumable": {
                return Optional.ofNullable(clazz.cast(this.isResumable()));
            }
            case "maxFileCount": {
                return Optional.ofNullable(clazz.cast(this.maxFileCount()));
            }
            case "maxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileUploaderFieldConfig, T> g) {
        return obj -> g.apply((FileUploaderFieldConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessLevel;
        private List<String> acceptedFileTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean showThumbnails;
        private Boolean isResumable;
        private Integer maxFileCount;
        private Integer maxSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FileUploaderFieldConfig model) {
            this.accessLevel(model.accessLevel);
            this.acceptedFileTypes(model.acceptedFileTypes);
            this.showThumbnails(model.showThumbnails);
            this.isResumable(model.isResumable);
            this.maxFileCount(model.maxFileCount);
            this.maxSize(model.maxSize);
        }

        public final String getAccessLevel() {
            return this.accessLevel;
        }

        public final void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        @Override
        public final Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        @Override
        public final Builder accessLevel(StorageAccessLevel accessLevel) {
            this.accessLevel(accessLevel == null ? null : accessLevel.toString());
            return this;
        }

        public final Collection<String> getAcceptedFileTypes() {
            if (this.acceptedFileTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceptedFileTypes;
        }

        public final void setAcceptedFileTypes(Collection<String> acceptedFileTypes) {
            this.acceptedFileTypes = StrValuesCopier.copy(acceptedFileTypes);
        }

        @Override
        public final Builder acceptedFileTypes(Collection<String> acceptedFileTypes) {
            this.acceptedFileTypes = StrValuesCopier.copy(acceptedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedFileTypes(String ... acceptedFileTypes) {
            this.acceptedFileTypes(Arrays.asList(acceptedFileTypes));
            return this;
        }

        public final Boolean getShowThumbnails() {
            return this.showThumbnails;
        }

        public final void setShowThumbnails(Boolean showThumbnails) {
            this.showThumbnails = showThumbnails;
        }

        @Override
        public final Builder showThumbnails(Boolean showThumbnails) {
            this.showThumbnails = showThumbnails;
            return this;
        }

        public final Boolean getIsResumable() {
            return this.isResumable;
        }

        public final void setIsResumable(Boolean isResumable) {
            this.isResumable = isResumable;
        }

        @Override
        public final Builder isResumable(Boolean isResumable) {
            this.isResumable = isResumable;
            return this;
        }

        public final Integer getMaxFileCount() {
            return this.maxFileCount;
        }

        public final void setMaxFileCount(Integer maxFileCount) {
            this.maxFileCount = maxFileCount;
        }

        @Override
        public final Builder maxFileCount(Integer maxFileCount) {
            this.maxFileCount = maxFileCount;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public FileUploaderFieldConfig build() {
            return new FileUploaderFieldConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileUploaderFieldConfig> {
        public Builder accessLevel(String var1);

        public Builder accessLevel(StorageAccessLevel var1);

        public Builder acceptedFileTypes(Collection<String> var1);

        public Builder acceptedFileTypes(String ... var1);

        public Builder showThumbnails(Boolean var1);

        public Builder isResumable(Boolean var1);

        public Builder maxFileCount(Integer var1);

        public Builder maxSize(Integer var1);
    }
}

