/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormActionType;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormSummary> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(FormSummary.getter(FormSummary::appId)).setter(FormSummary.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(FormSummary.getter(FormSummary::dataType)).setter(FormSummary.setter(Builder::dataType)).constructor(FormDataTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(FormSummary.getter(FormSummary::environmentName)).setter(FormSummary.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formActionType").getter(FormSummary.getter(FormSummary::formActionTypeAsString)).setter(FormSummary.setter(Builder::formActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FormSummary.getter(FormSummary::id)).setter(FormSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FormSummary.getter(FormSummary::name)).setter(FormSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, DATA_TYPE_FIELD, ENVIRONMENT_NAME_FIELD, FORM_ACTION_TYPE_FIELD, ID_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appId", APP_ID_FIELD);
            this.put("dataType", DATA_TYPE_FIELD);
            this.put("environmentName", ENVIRONMENT_NAME_FIELD);
            this.put("formActionType", FORM_ACTION_TYPE_FIELD);
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String appId;
    private final FormDataTypeConfig dataType;
    private final String environmentName;
    private final String formActionType;
    private final String id;
    private final String name;

    private FormSummary(BuilderImpl builder) {
        this.appId = builder.appId;
        this.dataType = builder.dataType;
        this.environmentName = builder.environmentName;
        this.formActionType = builder.formActionType;
        this.id = builder.id;
        this.name = builder.name;
    }

    public final String appId() {
        return this.appId;
    }

    public final FormDataTypeConfig dataType() {
        return this.dataType;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final FormActionType formActionType() {
        return FormActionType.fromValue(this.formActionType);
    }

    public final String formActionTypeAsString() {
        return this.formActionType;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormSummary)) {
            return false;
        }
        FormSummary other = (FormSummary)obj;
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.formActionTypeAsString(), other.formActionTypeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"FormSummary").add("AppId", (Object)this.appId()).add("DataType", (Object)this.dataType()).add("EnvironmentName", (Object)this.environmentName()).add("FormActionType", (Object)this.formActionTypeAsString()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "formActionType": {
                return Optional.ofNullable(clazz.cast(this.formActionTypeAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FormSummary, T> g) {
        return obj -> g.apply((FormSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private FormDataTypeConfig dataType;
        private String environmentName;
        private String formActionType;
        private String id;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(FormSummary model) {
            this.appId(model.appId);
            this.dataType(model.dataType);
            this.environmentName(model.environmentName);
            this.formActionType(model.formActionType);
            this.id(model.id);
            this.name(model.name);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getFormActionType() {
            return this.formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public FormSummary build() {
            return new FormSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormSummary> {
        public Builder appId(String var1);

        public Builder dataType(FormDataTypeConfig var1);

        default public Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return this.dataType((FormDataTypeConfig)((FormDataTypeConfig.Builder)FormDataTypeConfig.builder().applyMutation(dataType)).build());
        }

        public Builder environmentName(String var1);

        public Builder formActionType(String var1);

        public Builder formActionType(FormActionType var1);

        public Builder id(String var1);

        public Builder name(String var1);
    }
}

