/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormDataTypeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormDataTypeConfig> {
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(FormDataTypeConfig.getter(FormDataTypeConfig::dataSourceTypeAsString)).setter(FormDataTypeConfig.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final SdkField<String> DATA_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTypeName").getter(FormDataTypeConfig.getter(FormDataTypeConfig::dataTypeName)).setter(FormDataTypeConfig.setter(Builder::dataTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD, DATA_TYPE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
            this.put("dataTypeName", DATA_TYPE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataSourceType;
    private final String dataTypeName;

    private FormDataTypeConfig(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.dataTypeName = builder.dataTypeName;
    }

    public final FormDataSourceType dataSourceType() {
        return FormDataSourceType.fromValue(this.dataSourceType);
    }

    public final String dataSourceTypeAsString() {
        return this.dataSourceType;
    }

    public final String dataTypeName() {
        return this.dataTypeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormDataTypeConfig)) {
            return false;
        }
        FormDataTypeConfig other = (FormDataTypeConfig)obj;
        return Objects.equals(this.dataSourceTypeAsString(), other.dataSourceTypeAsString()) && Objects.equals(this.dataTypeName(), other.dataTypeName());
    }

    public final String toString() {
        return ToString.builder((String)"FormDataTypeConfig").add("DataSourceType", (Object)this.dataSourceTypeAsString()).add("DataTypeName", (Object)this.dataTypeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceTypeAsString()));
            }
            case "dataTypeName": {
                return Optional.ofNullable(clazz.cast(this.dataTypeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FormDataTypeConfig, T> g) {
        return obj -> g.apply((FormDataTypeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceType;
        private String dataTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FormDataTypeConfig model) {
            this.dataSourceType(model.dataSourceType);
            this.dataTypeName(model.dataTypeName);
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(FormDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final String getDataTypeName() {
            return this.dataTypeName;
        }

        public final void setDataTypeName(String dataTypeName) {
            this.dataTypeName = dataTypeName;
        }

        @Override
        public final Builder dataTypeName(String dataTypeName) {
            this.dataTypeName = dataTypeName;
            return this;
        }

        public FormDataTypeConfig build() {
            return new FormDataTypeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormDataTypeConfig> {
        public Builder dataSourceType(String var1);

        public Builder dataSourceType(FormDataSourceType var1);

        public Builder dataTypeName(String var1);
    }
}

