/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifyuibuilder.model.Component;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;

public class ExportComponentsPublisher
implements SdkPublisher<ExportComponentsResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ExportComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ExportComponentsPublisher(AmplifyUiBuilderAsyncClient client, ExportComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ExportComponentsPublisher(AmplifyUiBuilderAsyncClient client, ExportComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ExportComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ExportComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Component> entities() {
        Function<ExportComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ExportComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ExportComponentsResponseFetcher
    implements AsyncPageFetcher<ExportComponentsResponse> {
        private ExportComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ExportComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ExportComponentsResponse> nextPage(ExportComponentsResponse previousPage) {
            if (previousPage == null) {
                return ExportComponentsPublisher.this.client.exportComponents(ExportComponentsPublisher.this.firstRequest);
            }
            return ExportComponentsPublisher.this.client.exportComponents((ExportComponentsRequest)((Object)ExportComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

