/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodegenJobsResponse
extends AmplifyUiBuilderResponse
implements ToCopyableBuilder<Builder, ListCodegenJobsResponse> {
    private static final SdkField<List<CodegenJobSummary>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(ListCodegenJobsResponse.getter(ListCodegenJobsResponse::entities)).setter(ListCodegenJobsResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodegenJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCodegenJobsResponse.getter(ListCodegenJobsResponse::nextToken)).setter(ListCodegenJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CodegenJobSummary> entities;
    private final String nextToken;

    private ListCodegenJobsResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<CodegenJobSummary> entities() {
        return this.entities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodegenJobsResponse)) {
            return false;
        }
        ListCodegenJobsResponse other = (ListCodegenJobsResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCodegenJobsResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodegenJobsResponse, T> g) {
        return obj -> g.apply((ListCodegenJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderResponse.BuilderImpl
    implements Builder {
        private List<CodegenJobSummary> entities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodegenJobsResponse model) {
            super(model);
            this.entities(model.entities);
            this.nextToken(model.nextToken);
        }

        public final List<CodegenJobSummary.Builder> getEntities() {
            List<CodegenJobSummary.Builder> result = CodegenJobSummaryListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<CodegenJobSummary.BuilderImpl> entities) {
            this.entities = CodegenJobSummaryListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<CodegenJobSummary> entities) {
            this.entities = CodegenJobSummaryListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(CodegenJobSummary ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<CodegenJobSummary.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (CodegenJobSummary)((CodegenJobSummary.Builder)CodegenJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodegenJobsResponse build() {
            return new ListCodegenJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodegenJobsResponse> {
        public Builder entities(Collection<CodegenJobSummary> var1);

        public Builder entities(CodegenJobSummary ... var1);

        public Builder entities(Consumer<CodegenJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

