/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JSTarget {
    ES2015("es2015"),
    ES2020("es2020"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JSTarget> VALUE_MAP;
    private final String value;

    private JSTarget(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JSTarget fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JSTarget> knownValues() {
        EnumSet<JSTarget> knownValues = EnumSet.allOf(JSTarget.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JSTarget.class, JSTarget::toString);
    }
}

