/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Component;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportComponentsResponse
extends AmplifyUiBuilderResponse
implements ToCopyableBuilder<Builder, ExportComponentsResponse> {
    private static final SdkField<List<Component>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(ExportComponentsResponse.getter(ExportComponentsResponse::entities)).setter(ExportComponentsResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Component::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ExportComponentsResponse.getter(ExportComponentsResponse::nextToken)).setter(ExportComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Component> entities;
    private final String nextToken;

    private ExportComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<Component> entities() {
        return this.entities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportComponentsResponse)) {
            return false;
        }
        ExportComponentsResponse other = (ExportComponentsResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ExportComponentsResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportComponentsResponse, T> g) {
        return obj -> g.apply((ExportComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderResponse.BuilderImpl
    implements Builder {
        private List<Component> entities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportComponentsResponse model) {
            super(model);
            this.entities(model.entities);
            this.nextToken(model.nextToken);
        }

        public final List<Component.Builder> getEntities() {
            List<Component.Builder> result = ComponentListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Component.BuilderImpl> entities) {
            this.entities = ComponentListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Component> entities) {
            this.entities = ComponentListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Component ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Component.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Component)((Component.Builder)Component.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ExportComponentsResponse build() {
            return new ExportComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportComponentsResponse> {
        public Builder entities(Collection<Component> var1);

        public Builder entities(Component ... var1);

        public Builder entities(Consumer<Component.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

