/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse;

public class ListCodegenJobsPublisher
implements SdkPublisher<ListCodegenJobsResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ListCodegenJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCodegenJobsPublisher(AmplifyUiBuilderAsyncClient client, ListCodegenJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCodegenJobsPublisher(AmplifyUiBuilderAsyncClient client, ListCodegenJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCodegenJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCodegenJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CodegenJobSummary> entities() {
        Function<ListCodegenJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCodegenJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCodegenJobsResponseFetcher
    implements AsyncPageFetcher<ListCodegenJobsResponse> {
        private ListCodegenJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodegenJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCodegenJobsResponse> nextPage(ListCodegenJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCodegenJobsPublisher.this.client.listCodegenJobs(ListCodegenJobsPublisher.this.firstRequest);
            }
            return ListCodegenJobsPublisher.this.client.listCodegenJobs((ListCodegenJobsRequest)((Object)ListCodegenJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

