/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFormRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, UpdateFormRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateFormRequest.getter(UpdateFormRequest::appId)).setter(UpdateFormRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateFormRequest.getter(UpdateFormRequest::clientToken)).setter(UpdateFormRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(UpdateFormRequest.getter(UpdateFormRequest::environmentName)).setter(UpdateFormRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateFormRequest.getter(UpdateFormRequest::id)).setter(UpdateFormRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<UpdateFormData> UPDATED_FORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updatedForm").getter(UpdateFormRequest.getter(UpdateFormRequest::updatedForm)).setter(UpdateFormRequest.setter(Builder::updatedForm)).constructor(UpdateFormData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedForm").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, UPDATED_FORM_FIELD));
    private final String appId;
    private final String clientToken;
    private final String environmentName;
    private final String id;
    private final UpdateFormData updatedForm;

    private UpdateFormRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.updatedForm = builder.updatedForm;
    }

    public final String appId() {
        return this.appId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final UpdateFormData updatedForm() {
        return this.updatedForm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedForm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFormRequest)) {
            return false;
        }
        UpdateFormRequest other = (UpdateFormRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.updatedForm(), other.updatedForm());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFormRequest").add("AppId", (Object)this.appId()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("UpdatedForm", (Object)this.updatedForm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "updatedForm": {
                return Optional.ofNullable(clazz.cast(this.updatedForm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFormRequest, T> g) {
        return obj -> g.apply((UpdateFormRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String clientToken;
        private String environmentName;
        private String id;
        private UpdateFormData updatedForm;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFormRequest model) {
            super(model);
            this.appId(model.appId);
            this.clientToken(model.clientToken);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.updatedForm(model.updatedForm);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final UpdateFormData.Builder getUpdatedForm() {
            return this.updatedForm != null ? this.updatedForm.toBuilder() : null;
        }

        public final void setUpdatedForm(UpdateFormData.BuilderImpl updatedForm) {
            this.updatedForm = updatedForm != null ? updatedForm.build() : null;
        }

        @Override
        public final Builder updatedForm(UpdateFormData updatedForm) {
            this.updatedForm = updatedForm;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFormRequest build() {
            return new UpdateFormRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFormRequest> {
        public Builder appId(String var1);

        public Builder clientToken(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder updatedForm(UpdateFormData var1);

        default public Builder updatedForm(Consumer<UpdateFormData.Builder> updatedForm) {
            return this.updatedForm((UpdateFormData)((UpdateFormData.Builder)UpdateFormData.builder().applyMutation(updatedForm)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

