/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldsMapCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormActionType;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle;
import software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement;
import software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElementMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFormData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFormData> {
    private static final SdkField<FormCTA> CTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cta").getter(UpdateFormData.getter(UpdateFormData::cta)).setter(UpdateFormData.setter(Builder::cta)).constructor(FormCTA::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cta").build()}).build();
    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataType").getter(UpdateFormData.getter(UpdateFormData::dataType)).setter(UpdateFormData.setter(Builder::dataType)).constructor(FormDataTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Map<String, FieldConfig>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("fields").getter(UpdateFormData.getter(UpdateFormData::fields)).setter(UpdateFormData.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formActionType").getter(UpdateFormData.getter(UpdateFormData::formActionTypeAsString)).setter(UpdateFormData.setter(Builder::formActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFormData.getter(UpdateFormData::name)).setter(UpdateFormData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(UpdateFormData.getter(UpdateFormData::schemaVersion)).setter(UpdateFormData.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<Map<String, SectionalElement>> SECTIONAL_ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sectionalElements").getter(UpdateFormData.getter(UpdateFormData::sectionalElements)).setter(UpdateFormData.setter(Builder::sectionalElements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sectionalElements").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SectionalElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<FormStyle> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("style").getter(UpdateFormData.getter(UpdateFormData::style)).setter(UpdateFormData.setter(Builder::style)).constructor(FormStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("style").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CTA_FIELD, DATA_TYPE_FIELD, FIELDS_FIELD, FORM_ACTION_TYPE_FIELD, NAME_FIELD, SCHEMA_VERSION_FIELD, SECTIONAL_ELEMENTS_FIELD, STYLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final FormCTA cta;
    private final FormDataTypeConfig dataType;
    private final Map<String, FieldConfig> fields;
    private final String formActionType;
    private final String name;
    private final String schemaVersion;
    private final Map<String, SectionalElement> sectionalElements;
    private final FormStyle style;

    private UpdateFormData(BuilderImpl builder) {
        this.cta = builder.cta;
        this.dataType = builder.dataType;
        this.fields = builder.fields;
        this.formActionType = builder.formActionType;
        this.name = builder.name;
        this.schemaVersion = builder.schemaVersion;
        this.sectionalElements = builder.sectionalElements;
        this.style = builder.style;
    }

    public final FormCTA cta() {
        return this.cta;
    }

    public final FormDataTypeConfig dataType() {
        return this.dataType;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, FieldConfig> fields() {
        return this.fields;
    }

    public final FormActionType formActionType() {
        return FormActionType.fromValue(this.formActionType);
    }

    public final String formActionTypeAsString() {
        return this.formActionType;
    }

    public final String name() {
        return this.name;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final boolean hasSectionalElements() {
        return this.sectionalElements != null && !(this.sectionalElements instanceof SdkAutoConstructMap);
    }

    public final Map<String, SectionalElement> sectionalElements() {
        return this.sectionalElements;
    }

    public final FormStyle style() {
        return this.style;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cta());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSectionalElements() ? this.sectionalElements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFormData)) {
            return false;
        }
        UpdateFormData other = (UpdateFormData)obj;
        return Objects.equals(this.cta(), other.cta()) && Objects.equals(this.dataType(), other.dataType()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.formActionTypeAsString(), other.formActionTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && this.hasSectionalElements() == other.hasSectionalElements() && Objects.equals(this.sectionalElements(), other.sectionalElements()) && Objects.equals(this.style(), other.style());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFormData").add("Cta", (Object)this.cta()).add("DataType", (Object)this.dataType()).add("Fields", this.hasFields() ? this.fields() : null).add("FormActionType", (Object)this.formActionTypeAsString()).add("Name", (Object)this.name()).add("SchemaVersion", (Object)this.schemaVersion()).add("SectionalElements", this.hasSectionalElements() ? this.sectionalElements() : null).add("Style", (Object)this.style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cta": {
                return Optional.ofNullable(clazz.cast(this.cta()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "formActionType": {
                return Optional.ofNullable(clazz.cast(this.formActionTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "sectionalElements": {
                return Optional.ofNullable(clazz.cast(this.sectionalElements()));
            }
            case "style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFormData, T> g) {
        return obj -> g.apply((UpdateFormData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FormCTA cta;
        private FormDataTypeConfig dataType;
        private Map<String, FieldConfig> fields = DefaultSdkAutoConstructMap.getInstance();
        private String formActionType;
        private String name;
        private String schemaVersion;
        private Map<String, SectionalElement> sectionalElements = DefaultSdkAutoConstructMap.getInstance();
        private FormStyle style;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFormData model) {
            this.cta(model.cta);
            this.dataType(model.dataType);
            this.fields(model.fields);
            this.formActionType(model.formActionType);
            this.name(model.name);
            this.schemaVersion(model.schemaVersion);
            this.sectionalElements(model.sectionalElements);
            this.style(model.style);
        }

        public final FormCTA.Builder getCta() {
            return this.cta != null ? this.cta.toBuilder() : null;
        }

        public final void setCta(FormCTA.BuilderImpl cta) {
            this.cta = cta != null ? cta.build() : null;
        }

        @Override
        public final Builder cta(FormCTA cta) {
            this.cta = cta;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return this.dataType != null ? this.dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final Map<String, FieldConfig.Builder> getFields() {
            Map<String, FieldConfig.Builder> result = FieldsMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, FieldConfig.BuilderImpl> fields) {
            this.fields = FieldsMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, FieldConfig> fields) {
            this.fields = FieldsMapCopier.copy(fields);
            return this;
        }

        public final String getFormActionType() {
            return this.formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Map<String, SectionalElement.Builder> getSectionalElements() {
            Map<String, SectionalElement.Builder> result = SectionalElementMapCopier.copyToBuilder(this.sectionalElements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSectionalElements(Map<String, SectionalElement.BuilderImpl> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copyFromBuilder(sectionalElements);
        }

        @Override
        public final Builder sectionalElements(Map<String, SectionalElement> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copy(sectionalElements);
            return this;
        }

        public final FormStyle.Builder getStyle() {
            return this.style != null ? this.style.toBuilder() : null;
        }

        public final void setStyle(FormStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(FormStyle style) {
            this.style = style;
            return this;
        }

        public UpdateFormData build() {
            return new UpdateFormData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFormData> {
        public Builder cta(FormCTA var1);

        default public Builder cta(Consumer<FormCTA.Builder> cta) {
            return this.cta((FormCTA)((FormCTA.Builder)FormCTA.builder().applyMutation(cta)).build());
        }

        public Builder dataType(FormDataTypeConfig var1);

        default public Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return this.dataType((FormDataTypeConfig)((FormDataTypeConfig.Builder)FormDataTypeConfig.builder().applyMutation(dataType)).build());
        }

        public Builder fields(Map<String, FieldConfig> var1);

        public Builder formActionType(String var1);

        public Builder formActionType(FormActionType var1);

        public Builder name(String var1);

        public Builder schemaVersion(String var1);

        public Builder sectionalElements(Map<String, SectionalElement> var1);

        public Builder style(FormStyle var1);

        default public Builder style(Consumer<FormStyle.Builder> style) {
            return this.style((FormStyle)((FormStyle.Builder)FormStyle.builder().applyMutation(style)).build());
        }
    }
}

