/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Form;

public class ExportFormsIterable
implements SdkIterable<ExportFormsResponse> {
    private final AmplifyUiBuilderClient client;
    private final ExportFormsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ExportFormsIterable(AmplifyUiBuilderClient client, ExportFormsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ExportFormsResponseFetcher();
    }

    public Iterator<ExportFormsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Form> entities() {
        Function<ExportFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ExportFormsResponseFetcher
    implements SyncPageFetcher<ExportFormsResponse> {
        private ExportFormsResponseFetcher() {
        }

        public boolean hasNextPage(ExportFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ExportFormsResponse nextPage(ExportFormsResponse previousPage) {
            if (previousPage == null) {
                return ExportFormsIterable.this.client.exportForms(ExportFormsIterable.this.firstRequest);
            }
            return ExportFormsIterable.this.client.exportForms((ExportFormsRequest)((Object)ExportFormsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

