/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentOverridesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariantValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentVariant> {
    private static final SdkField<Map<String, Map<String, String>>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("overrides").getter(ComponentVariant.getter(ComponentVariant::overrides)).setter(ComponentVariant.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VARIANT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variantValues").getter(ComponentVariant.getter(ComponentVariant::variantValues)).setter(ComponentVariant.setter(Builder::variantValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDES_FIELD, VARIANT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, String>> overrides;
    private final Map<String, String> variantValues;

    private ComponentVariant(BuilderImpl builder) {
        this.overrides = builder.overrides;
        this.variantValues = builder.variantValues;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> overrides() {
        return this.overrides;
    }

    public final boolean hasVariantValues() {
        return this.variantValues != null && !(this.variantValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variantValues() {
        return this.variantValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantValues() ? this.variantValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVariant)) {
            return false;
        }
        ComponentVariant other = (ComponentVariant)obj;
        return this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides()) && this.hasVariantValues() == other.hasVariantValues() && Objects.equals(this.variantValues(), other.variantValues());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentVariant").add("Overrides", this.hasOverrides() ? this.overrides() : null).add("VariantValues", this.hasVariantValues() ? this.variantValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "variantValues": {
                return Optional.ofNullable(clazz.cast(this.variantValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentVariant, T> g) {
        return obj -> g.apply((ComponentVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Map<String, String>> overrides = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> variantValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVariant model) {
            this.overrides(model.overrides);
            this.variantValues(model.variantValues);
        }

        public final Map<String, ? extends Map<String, String>> getOverrides() {
            if (this.overrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrides;
        }

        public final void setOverrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
            return this;
        }

        public final Map<String, String> getVariantValues() {
            if (this.variantValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variantValues;
        }

        public final void setVariantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
        }

        @Override
        @Transient
        public final Builder variantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
            return this;
        }

        public ComponentVariant build() {
            return new ComponentVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentVariant> {
        public Builder overrides(Map<String, ? extends Map<String, String>> var1);

        public Builder variantValues(Map<String, String> var1);
    }
}

