/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyListCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingElement;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormBindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentProperty> {
    private static final SdkField<ComponentPropertyBindingProperties> BINDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bindingProperties").getter(ComponentProperty.getter(ComponentProperty::bindingProperties)).setter(ComponentProperty.setter(Builder::bindingProperties)).constructor(ComponentPropertyBindingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build()}).build();
    private static final SdkField<Map<String, FormBindingElement>> BINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("bindings").getter(ComponentProperty.getter(ComponentProperty::bindings)).setter(ComponentProperty.setter(Builder::bindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormBindingElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ComponentPropertyBindingProperties> COLLECTION_BINDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collectionBindingProperties").getter(ComponentProperty.getter(ComponentProperty::collectionBindingProperties)).setter(ComponentProperty.setter(Builder::collectionBindingProperties)).constructor(ComponentPropertyBindingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionBindingProperties").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentProperty.getter(ComponentProperty::componentName)).setter(ComponentProperty.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<List<ComponentProperty>> CONCAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("concat").getter(ComponentProperty.getter(ComponentProperty::concat)).setter(ComponentProperty.setter(Builder::concat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concat").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ComponentConditionProperty> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("condition").getter(ComponentProperty.getter(ComponentProperty::condition)).setter(ComponentProperty.setter(Builder::condition)).constructor(ComponentConditionProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final SdkField<Boolean> CONFIGURED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("configured").getter(ComponentProperty.getter(ComponentProperty::configured)).setter(ComponentProperty.setter(Builder::configured)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configured").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(ComponentProperty.getter(ComponentProperty::defaultValue)).setter(ComponentProperty.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(ComponentProperty.getter(ComponentProperty::event)).setter(ComponentProperty.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<String> IMPORTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedValue").getter(ComponentProperty.getter(ComponentProperty::importedValue)).setter(ComponentProperty.setter(Builder::importedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedValue").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(ComponentProperty.getter(ComponentProperty::model)).setter(ComponentProperty.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("property").getter(ComponentProperty.getter(ComponentProperty::property)).setter(ComponentProperty.setter(Builder::property)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComponentProperty.getter(ComponentProperty::type)).setter(ComponentProperty.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAttribute").getter(ComponentProperty.getter(ComponentProperty::userAttribute)).setter(ComponentProperty.setter(Builder::userAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(ComponentProperty.getter(ComponentProperty::value)).setter(ComponentProperty.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINDING_PROPERTIES_FIELD, BINDINGS_FIELD, COLLECTION_BINDING_PROPERTIES_FIELD, COMPONENT_NAME_FIELD, CONCAT_FIELD, CONDITION_FIELD, CONFIGURED_FIELD, DEFAULT_VALUE_FIELD, EVENT_FIELD, IMPORTED_VALUE_FIELD, MODEL_FIELD, PROPERTY_FIELD, TYPE_FIELD, USER_ATTRIBUTE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ComponentPropertyBindingProperties bindingProperties;
    private final Map<String, FormBindingElement> bindings;
    private final ComponentPropertyBindingProperties collectionBindingProperties;
    private final String componentName;
    private final List<ComponentProperty> concat;
    private final ComponentConditionProperty condition;
    private final Boolean configured;
    private final String defaultValue;
    private final String event;
    private final String importedValue;
    private final String model;
    private final String property;
    private final String type;
    private final String userAttribute;
    private final String value;

    private ComponentProperty(BuilderImpl builder) {
        this.bindingProperties = builder.bindingProperties;
        this.bindings = builder.bindings;
        this.collectionBindingProperties = builder.collectionBindingProperties;
        this.componentName = builder.componentName;
        this.concat = builder.concat;
        this.condition = builder.condition;
        this.configured = builder.configured;
        this.defaultValue = builder.defaultValue;
        this.event = builder.event;
        this.importedValue = builder.importedValue;
        this.model = builder.model;
        this.property = builder.property;
        this.type = builder.type;
        this.userAttribute = builder.userAttribute;
        this.value = builder.value;
    }

    public final ComponentPropertyBindingProperties bindingProperties() {
        return this.bindingProperties;
    }

    public final boolean hasBindings() {
        return this.bindings != null && !(this.bindings instanceof SdkAutoConstructMap);
    }

    public final Map<String, FormBindingElement> bindings() {
        return this.bindings;
    }

    public final ComponentPropertyBindingProperties collectionBindingProperties() {
        return this.collectionBindingProperties;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final boolean hasConcat() {
        return this.concat != null && !(this.concat instanceof SdkAutoConstructList);
    }

    public final List<ComponentProperty> concat() {
        return this.concat;
    }

    public final ComponentConditionProperty condition() {
        return this.condition;
    }

    public final Boolean configured() {
        return this.configured;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String event() {
        return this.event;
    }

    public final String importedValue() {
        return this.importedValue;
    }

    public final String model() {
        return this.model;
    }

    public final String property() {
        return this.property;
    }

    public final String type() {
        return this.type;
    }

    public final String userAttribute() {
        return this.userAttribute;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBindings() ? this.bindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionBindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConcat() ? this.concat() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.configured());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.property());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentProperty)) {
            return false;
        }
        ComponentProperty other = (ComponentProperty)obj;
        return Objects.equals(this.bindingProperties(), other.bindingProperties()) && this.hasBindings() == other.hasBindings() && Objects.equals(this.bindings(), other.bindings()) && Objects.equals(this.collectionBindingProperties(), other.collectionBindingProperties()) && Objects.equals(this.componentName(), other.componentName()) && this.hasConcat() == other.hasConcat() && Objects.equals(this.concat(), other.concat()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.configured(), other.configured()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.event(), other.event()) && Objects.equals(this.importedValue(), other.importedValue()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.property(), other.property()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.userAttribute(), other.userAttribute()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentProperty").add("BindingProperties", (Object)this.bindingProperties()).add("Bindings", this.hasBindings() ? this.bindings() : null).add("CollectionBindingProperties", (Object)this.collectionBindingProperties()).add("ComponentName", (Object)this.componentName()).add("Concat", this.hasConcat() ? this.concat() : null).add("Condition", (Object)this.condition()).add("Configured", (Object)this.configured()).add("DefaultValue", (Object)this.defaultValue()).add("Event", (Object)this.event()).add("ImportedValue", (Object)this.importedValue()).add("Model", (Object)this.model()).add("Property", (Object)this.property()).add("Type", (Object)this.type()).add("UserAttribute", (Object)this.userAttribute()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bindingProperties": {
                return Optional.ofNullable(clazz.cast(this.bindingProperties()));
            }
            case "bindings": {
                return Optional.ofNullable(clazz.cast(this.bindings()));
            }
            case "collectionBindingProperties": {
                return Optional.ofNullable(clazz.cast(this.collectionBindingProperties()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "concat": {
                return Optional.ofNullable(clazz.cast(this.concat()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "configured": {
                return Optional.ofNullable(clazz.cast(this.configured()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "importedValue": {
                return Optional.ofNullable(clazz.cast(this.importedValue()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "property": {
                return Optional.ofNullable(clazz.cast(this.property()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "userAttribute": {
                return Optional.ofNullable(clazz.cast(this.userAttribute()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentProperty, T> g) {
        return obj -> g.apply((ComponentProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ComponentPropertyBindingProperties bindingProperties;
        private Map<String, FormBindingElement> bindings = DefaultSdkAutoConstructMap.getInstance();
        private ComponentPropertyBindingProperties collectionBindingProperties;
        private String componentName;
        private List<ComponentProperty> concat = DefaultSdkAutoConstructList.getInstance();
        private ComponentConditionProperty condition;
        private Boolean configured;
        private String defaultValue;
        private String event;
        private String importedValue;
        private String model;
        private String property;
        private String type;
        private String userAttribute;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentProperty model) {
            this.bindingProperties(model.bindingProperties);
            this.bindings(model.bindings);
            this.collectionBindingProperties(model.collectionBindingProperties);
            this.componentName(model.componentName);
            this.concat(model.concat);
            this.condition(model.condition);
            this.configured(model.configured);
            this.defaultValue(model.defaultValue);
            this.event(model.event);
            this.importedValue(model.importedValue);
            this.model(model.model);
            this.property(model.property);
            this.type(model.type);
            this.userAttribute(model.userAttribute);
            this.value(model.value);
        }

        public final ComponentPropertyBindingProperties.Builder getBindingProperties() {
            return this.bindingProperties != null ? this.bindingProperties.toBuilder() : null;
        }

        public final void setBindingProperties(ComponentPropertyBindingProperties.BuilderImpl bindingProperties) {
            this.bindingProperties = bindingProperties != null ? bindingProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder bindingProperties(ComponentPropertyBindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        public final Map<String, FormBindingElement.Builder> getBindings() {
            Map<String, FormBindingElement.Builder> result = FormBindingsCopier.copyToBuilder(this.bindings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindings(Map<String, FormBindingElement.BuilderImpl> bindings) {
            this.bindings = FormBindingsCopier.copyFromBuilder(bindings);
        }

        @Override
        @Transient
        public final Builder bindings(Map<String, FormBindingElement> bindings) {
            this.bindings = FormBindingsCopier.copy(bindings);
            return this;
        }

        public final ComponentPropertyBindingProperties.Builder getCollectionBindingProperties() {
            return this.collectionBindingProperties != null ? this.collectionBindingProperties.toBuilder() : null;
        }

        public final void setCollectionBindingProperties(ComponentPropertyBindingProperties.BuilderImpl collectionBindingProperties) {
            this.collectionBindingProperties = collectionBindingProperties != null ? collectionBindingProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder collectionBindingProperties(ComponentPropertyBindingProperties collectionBindingProperties) {
            this.collectionBindingProperties = collectionBindingProperties;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        @Transient
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final List<Builder> getConcat() {
            List<Builder> result = ComponentPropertyListCopier.copyToBuilder(this.concat);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConcat(Collection<BuilderImpl> concat) {
            this.concat = ComponentPropertyListCopier.copyFromBuilder(concat);
        }

        @Override
        @Transient
        public final Builder concat(Collection<ComponentProperty> concat) {
            this.concat = ComponentPropertyListCopier.copy(concat);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder concat(ComponentProperty ... concat) {
            this.concat(Arrays.asList(concat));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder concat(Consumer<Builder> ... concat) {
            this.concat(Stream.of(concat).map(c -> (ComponentProperty)((Builder)ComponentProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ComponentConditionProperty.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(ComponentConditionProperty.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        @Transient
        public final Builder condition(ComponentConditionProperty condition) {
            this.condition = condition;
            return this;
        }

        public final Boolean getConfigured() {
            return this.configured;
        }

        public final void setConfigured(Boolean configured) {
            this.configured = configured;
        }

        @Override
        @Transient
        public final Builder configured(Boolean configured) {
            this.configured = configured;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Transient
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final String getImportedValue() {
            return this.importedValue;
        }

        public final void setImportedValue(String importedValue) {
            this.importedValue = importedValue;
        }

        @Override
        @Transient
        public final Builder importedValue(String importedValue) {
            this.importedValue = importedValue;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getProperty() {
            return this.property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        @Transient
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUserAttribute() {
            return this.userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        @Transient
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public ComponentProperty build() {
            return new ComponentProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentProperty> {
        public Builder bindingProperties(ComponentPropertyBindingProperties var1);

        default public Builder bindingProperties(Consumer<ComponentPropertyBindingProperties.Builder> bindingProperties) {
            return this.bindingProperties((ComponentPropertyBindingProperties)((ComponentPropertyBindingProperties.Builder)ComponentPropertyBindingProperties.builder().applyMutation(bindingProperties)).build());
        }

        public Builder bindings(Map<String, FormBindingElement> var1);

        public Builder collectionBindingProperties(ComponentPropertyBindingProperties var1);

        default public Builder collectionBindingProperties(Consumer<ComponentPropertyBindingProperties.Builder> collectionBindingProperties) {
            return this.collectionBindingProperties((ComponentPropertyBindingProperties)((ComponentPropertyBindingProperties.Builder)ComponentPropertyBindingProperties.builder().applyMutation(collectionBindingProperties)).build());
        }

        public Builder componentName(String var1);

        public Builder concat(Collection<ComponentProperty> var1);

        public Builder concat(ComponentProperty ... var1);

        public Builder concat(Consumer<Builder> ... var1);

        public Builder condition(ComponentConditionProperty var1);

        default public Builder condition(Consumer<ComponentConditionProperty.Builder> condition) {
            return this.condition((ComponentConditionProperty)((ComponentConditionProperty.Builder)ComponentConditionProperty.builder().applyMutation(condition)).build());
        }

        public Builder configured(Boolean var1);

        public Builder defaultValue(String var1);

        public Builder event(String var1);

        public Builder importedValue(String var1);

        public Builder model(String var1);

        public Builder property(String var1);

        public Builder type(String var1);

        public Builder userAttribute(String var1);

        public Builder value(String var1);
    }
}

