/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>(DEPRECATED)</b> Describes the forgot password policy for authenticating into the Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendAuthForgotPasswordConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateBackendAuthForgotPasswordConfig.Builder, CreateBackendAuthForgotPasswordConfig> {
    private static final SdkField<String> DELIVERY_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryMethod").getter(getter(CreateBackendAuthForgotPasswordConfig::deliveryMethodAsString))
            .setter(setter(Builder::deliveryMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryMethod").build()).build();

    private static final SdkField<EmailSettings> EMAIL_SETTINGS_FIELD = SdkField
            .<EmailSettings> builder(MarshallingType.SDK_POJO).memberName("EmailSettings")
            .getter(getter(CreateBackendAuthForgotPasswordConfig::emailSettings)).setter(setter(Builder::emailSettings))
            .constructor(EmailSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailSettings").build()).build();

    private static final SdkField<SmsSettings> SMS_SETTINGS_FIELD = SdkField.<SmsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("SmsSettings").getter(getter(CreateBackendAuthForgotPasswordConfig::smsSettings))
            .setter(setter(Builder::smsSettings)).constructor(SmsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_METHOD_FIELD,
            EMAIL_SETTINGS_FIELD, SMS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deliveryMethod;

    private final EmailSettings emailSettings;

    private final SmsSettings smsSettings;

    private CreateBackendAuthForgotPasswordConfig(BuilderImpl builder) {
        this.deliveryMethod = builder.deliveryMethod;
        this.emailSettings = builder.emailSettings;
        this.smsSettings = builder.smsSettings;
    }

    /**
     * <p>
     * <b>(DEPRECATED)</b> Describes which mode to use (either SMS or email) to deliver messages to app users who want
     * to recover their password.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMethod}
     * will return {@link DeliveryMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMethodAsString}.
     * </p>
     * 
     * @return (DEPRECATED)
     * @see DeliveryMethod
     */
    public final DeliveryMethod deliveryMethod() {
        return DeliveryMethod.fromValue(deliveryMethod);
    }

    /**
     * <p>
     * <b>(DEPRECATED)</b> Describes which mode to use (either SMS or email) to deliver messages to app users who want
     * to recover their password.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMethod}
     * will return {@link DeliveryMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryMethodAsString}.
     * </p>
     * 
     * @return (DEPRECATED)
     * @see DeliveryMethod
     */
    public final String deliveryMethodAsString() {
        return deliveryMethod;
    }

    /**
     * <p>
     * <b>(DEPRECATED)</b> The configuration for the email sent when an app user forgets their password.
     * </p>
     * 
     * @return (DEPRECATED)
     */
    public final EmailSettings emailSettings() {
        return emailSettings;
    }

    /**
     * <p>
     * <b>(DEPRECATED)</b> The configuration for the SMS message sent when an app user forgets their password.
     * </p>
     * 
     * @return (DEPRECATED)
     */
    public final SmsSettings smsSettings() {
        return smsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(emailSettings());
        hashCode = 31 * hashCode + Objects.hashCode(smsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthForgotPasswordConfig)) {
            return false;
        }
        CreateBackendAuthForgotPasswordConfig other = (CreateBackendAuthForgotPasswordConfig) obj;
        return Objects.equals(deliveryMethodAsString(), other.deliveryMethodAsString())
                && Objects.equals(emailSettings(), other.emailSettings()) && Objects.equals(smsSettings(), other.smsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendAuthForgotPasswordConfig").add("DeliveryMethod", deliveryMethodAsString())
                .add("EmailSettings", emailSettings()).add("SmsSettings", smsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryMethod":
            return Optional.ofNullable(clazz.cast(deliveryMethodAsString()));
        case "EmailSettings":
            return Optional.ofNullable(clazz.cast(emailSettings()));
        case "SmsSettings":
            return Optional.ofNullable(clazz.cast(smsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthForgotPasswordConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthForgotPasswordConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateBackendAuthForgotPasswordConfig> {
        /**
         * <p>
         * <b>(DEPRECATED)</b> Describes which mode to use (either SMS or email) to deliver messages to app users who
         * want to recover their password.
         * </p>
         * 
         * @param deliveryMethod
         *        (DEPRECATED)
         * @see DeliveryMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMethod
         */
        Builder deliveryMethod(String deliveryMethod);

        /**
         * <p>
         * <b>(DEPRECATED)</b> Describes which mode to use (either SMS or email) to deliver messages to app users who
         * want to recover their password.
         * </p>
         * 
         * @param deliveryMethod
         *        (DEPRECATED)
         * @see DeliveryMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryMethod
         */
        Builder deliveryMethod(DeliveryMethod deliveryMethod);

        /**
         * <p>
         * <b>(DEPRECATED)</b> The configuration for the email sent when an app user forgets their password.
         * </p>
         * 
         * @param emailSettings
         *        (DEPRECATED)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSettings(EmailSettings emailSettings);

        /**
         * <p>
         * <b>(DEPRECATED)</b> The configuration for the email sent when an app user forgets their password.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailSettings.Builder} avoiding the need
         * to create one manually via {@link EmailSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #emailSettings(EmailSettings)}.
         * 
         * @param emailSettings
         *        a consumer that will call methods on {@link EmailSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailSettings(EmailSettings)
         */
        default Builder emailSettings(Consumer<EmailSettings.Builder> emailSettings) {
            return emailSettings(EmailSettings.builder().applyMutation(emailSettings).build());
        }

        /**
         * <p>
         * <b>(DEPRECATED)</b> The configuration for the SMS message sent when an app user forgets their password.
         * </p>
         * 
         * @param smsSettings
         *        (DEPRECATED)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsSettings(SmsSettings smsSettings);

        /**
         * <p>
         * <b>(DEPRECATED)</b> The configuration for the SMS message sent when an app user forgets their password.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmsSettings.Builder} avoiding the need to
         * create one manually via {@link SmsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #smsSettings(SmsSettings)}.
         * 
         * @param smsSettings
         *        a consumer that will call methods on {@link SmsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsSettings(SmsSettings)
         */
        default Builder smsSettings(Consumer<SmsSettings.Builder> smsSettings) {
            return smsSettings(SmsSettings.builder().applyMutation(smsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deliveryMethod;

        private EmailSettings emailSettings;

        private SmsSettings smsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthForgotPasswordConfig model) {
            deliveryMethod(model.deliveryMethod);
            emailSettings(model.emailSettings);
            smsSettings(model.smsSettings);
        }

        public final String getDeliveryMethod() {
            return deliveryMethod;
        }

        public final void setDeliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
        }

        @Override
        public final Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        @Override
        public final Builder deliveryMethod(DeliveryMethod deliveryMethod) {
            this.deliveryMethod(deliveryMethod == null ? null : deliveryMethod.toString());
            return this;
        }

        public final EmailSettings.Builder getEmailSettings() {
            return emailSettings != null ? emailSettings.toBuilder() : null;
        }

        public final void setEmailSettings(EmailSettings.BuilderImpl emailSettings) {
            this.emailSettings = emailSettings != null ? emailSettings.build() : null;
        }

        @Override
        public final Builder emailSettings(EmailSettings emailSettings) {
            this.emailSettings = emailSettings;
            return this;
        }

        public final SmsSettings.Builder getSmsSettings() {
            return smsSettings != null ? smsSettings.toBuilder() : null;
        }

        public final void setSmsSettings(SmsSettings.BuilderImpl smsSettings) {
            this.smsSettings = smsSettings != null ? smsSettings.build() : null;
        }

        @Override
        public final Builder smsSettings(SmsSettings smsSettings) {
            this.smsSettings = smsSettings;
            return this;
        }

        @Override
        public CreateBackendAuthForgotPasswordConfig build() {
            return new CreateBackendAuthForgotPasswordConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
