/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.CertificateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateSettings> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CertificateSettings.getter(CertificateSettings::typeAsString)).setter(CertificateSettings.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CUSTOM_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customCertificateArn").getter(CertificateSettings.getter(CertificateSettings::customCertificateArn)).setter(CertificateSettings.setter(Builder::customCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customCertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CUSTOM_CERTIFICATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CertificateSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String customCertificateArn;

    private CertificateSettings(BuilderImpl builder) {
        this.type = builder.type;
        this.customCertificateArn = builder.customCertificateArn;
    }

    public final CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String customCertificateArn() {
        return this.customCertificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customCertificateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSettings)) {
            return false;
        }
        CertificateSettings other = (CertificateSettings)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.customCertificateArn(), other.customCertificateArn());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateSettings").add("Type", (Object)this.typeAsString()).add("CustomCertificateArn", (Object)this.customCertificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "customCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.customCertificateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("type", TYPE_FIELD);
        map.put("customCertificateArn", CUSTOM_CERTIFICATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateSettings, T> g) {
        return obj -> g.apply((CertificateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String customCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSettings model) {
            this.type(model.type);
            this.customCertificateArn(model.customCertificateArn);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCustomCertificateArn() {
            return this.customCertificateArn;
        }

        public final void setCustomCertificateArn(String customCertificateArn) {
            this.customCertificateArn = customCertificateArn;
        }

        @Override
        public final Builder customCertificateArn(String customCertificateArn) {
            this.customCertificateArn = customCertificateArn;
            return this;
        }

        public CertificateSettings build() {
            return new CertificateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateSettings> {
        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder customCertificateArn(String var1);
    }
}

