/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.WafStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WafConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WafConfiguration> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webAclArn").getter(WafConfiguration.getter(WafConfiguration::webAclArn)).setter(WafConfiguration.setter(Builder::webAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAclArn").build()}).build();
    private static final SdkField<String> WAF_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wafStatus").getter(WafConfiguration.getter(WafConfiguration::wafStatusAsString)).setter(WafConfiguration.setter(Builder::wafStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafStatus").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(WafConfiguration.getter(WafConfiguration::statusReason)).setter(WafConfiguration.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD, WAF_STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WafConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String webAclArn;
    private final String wafStatus;
    private final String statusReason;

    private WafConfiguration(BuilderImpl builder) {
        this.webAclArn = builder.webAclArn;
        this.wafStatus = builder.wafStatus;
        this.statusReason = builder.statusReason;
    }

    public final String webAclArn() {
        return this.webAclArn;
    }

    public final WafStatus wafStatus() {
        return WafStatus.fromValue(this.wafStatus);
    }

    public final String wafStatusAsString() {
        return this.wafStatus;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.wafStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WafConfiguration)) {
            return false;
        }
        WafConfiguration other = (WafConfiguration)obj;
        return Objects.equals(this.webAclArn(), other.webAclArn()) && Objects.equals(this.wafStatusAsString(), other.wafStatusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"WafConfiguration").add("WebAclArn", (Object)this.webAclArn()).add("WafStatus", (Object)this.wafStatusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "webAclArn": {
                return Optional.ofNullable(clazz.cast(this.webAclArn()));
            }
            case "wafStatus": {
                return Optional.ofNullable(clazz.cast(this.wafStatusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("webAclArn", WEB_ACL_ARN_FIELD);
        map.put("wafStatus", WAF_STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WafConfiguration, T> g) {
        return obj -> g.apply((WafConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String webAclArn;
        private String wafStatus;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(WafConfiguration model) {
            this.webAclArn(model.webAclArn);
            this.wafStatus(model.wafStatus);
            this.statusReason(model.statusReason);
        }

        public final String getWebAclArn() {
            return this.webAclArn;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public final String getWafStatus() {
            return this.wafStatus;
        }

        public final void setWafStatus(String wafStatus) {
            this.wafStatus = wafStatus;
        }

        @Override
        public final Builder wafStatus(String wafStatus) {
            this.wafStatus = wafStatus;
            return this;
        }

        @Override
        public final Builder wafStatus(WafStatus wafStatus) {
            this.wafStatus(wafStatus == null ? null : wafStatus.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public WafConfiguration build() {
            return new WafConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WafConfiguration> {
        public Builder webAclArn(String var1);

        public Builder wafStatus(String var1);

        public Builder wafStatus(WafStatus var1);

        public Builder statusReason(String var1);
    }
}

