/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.SourceUrlType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeploymentRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, StartDeploymentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::appId)).setter(StartDeploymentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(StartDeploymentRequest.getter(StartDeploymentRequest::branchName)).setter(StartDeploymentRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::jobId)).setter(StartDeploymentRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceUrl").getter(StartDeploymentRequest.getter(StartDeploymentRequest::sourceUrl)).setter(StartDeploymentRequest.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()}).build();
    private static final SdkField<String> SOURCE_URL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceUrlType").getter(StartDeploymentRequest.getter(StartDeploymentRequest::sourceUrlTypeAsString)).setter(StartDeploymentRequest.setter(Builder::sourceUrlType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrlType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BRANCH_NAME_FIELD, JOB_ID_FIELD, SOURCE_URL_FIELD, SOURCE_URL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appId", APP_ID_FIELD);
            this.put("branchName", BRANCH_NAME_FIELD);
            this.put("jobId", JOB_ID_FIELD);
            this.put("sourceUrl", SOURCE_URL_FIELD);
            this.put("sourceUrlType", SOURCE_URL_TYPE_FIELD);
        }
    });
    private final String appId;
    private final String branchName;
    private final String jobId;
    private final String sourceUrl;
    private final String sourceUrlType;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.jobId = builder.jobId;
        this.sourceUrl = builder.sourceUrl;
        this.sourceUrlType = builder.sourceUrlType;
    }

    public final String appId() {
        return this.appId;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String sourceUrl() {
        return this.sourceUrl;
    }

    public final SourceUrlType sourceUrlType() {
        return SourceUrlType.fromValue(this.sourceUrlType);
    }

    public final String sourceUrlTypeAsString() {
        return this.sourceUrlType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrlTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && Objects.equals(this.sourceUrlTypeAsString(), other.sourceUrlTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartDeploymentRequest").add("AppId", (Object)this.appId()).add("BranchName", (Object)this.branchName()).add("JobId", (Object)this.jobId()).add("SourceUrl", (Object)this.sourceUrl()).add("SourceUrlType", (Object)this.sourceUrlTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "sourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "sourceUrlType": {
                return Optional.ofNullable(clazz.cast(this.sourceUrlTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String branchName;
        private String jobId;
        private String sourceUrl;
        private String sourceUrlType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            this.appId(model.appId);
            this.branchName(model.branchName);
            this.jobId(model.jobId);
            this.sourceUrl(model.sourceUrl);
            this.sourceUrlType(model.sourceUrlType);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final String getSourceUrlType() {
            return this.sourceUrlType;
        }

        public final void setSourceUrlType(String sourceUrlType) {
            this.sourceUrlType = sourceUrlType;
        }

        @Override
        public final Builder sourceUrlType(String sourceUrlType) {
            this.sourceUrlType = sourceUrlType;
            return this;
        }

        @Override
        public final Builder sourceUrlType(SourceUrlType sourceUrlType) {
            this.sourceUrlType(sourceUrlType == null ? null : sourceUrlType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeploymentRequest> {
        public Builder appId(String var1);

        public Builder branchName(String var1);

        public Builder jobId(String var1);

        public Builder sourceUrl(String var1);

        public Builder sourceUrlType(String var1);

        public Builder sourceUrlType(SourceUrlType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

