/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplify.AmplifyClient;
import software.amazon.awssdk.services.amplify.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplify.model.DomainAssociation;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsRequest;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse;

public class ListDomainAssociationsIterable
implements SdkIterable<ListDomainAssociationsResponse> {
    private final AmplifyClient client;
    private final ListDomainAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainAssociationsIterable(AmplifyClient client, ListDomainAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainAssociationsResponseFetcher();
    }

    public Iterator<ListDomainAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainAssociation> domainAssociations() {
        Function<ListDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainAssociations() != null) {
                return response.domainAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainAssociationsResponseFetcher
    implements SyncPageFetcher<ListDomainAssociationsResponse> {
        private ListDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainAssociationsResponse nextPage(ListDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainAssociationsIterable.this.client.listDomainAssociations(ListDomainAssociationsIterable.this.firstRequest);
            }
            return ListDomainAssociationsIterable.this.client.listDomainAssociations((ListDomainAssociationsRequest)((Object)ListDomainAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

