/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplify.AmplifyClient;
import software.amazon.awssdk.services.amplify.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplify.model.JobSummary;
import software.amazon.awssdk.services.amplify.model.ListJobsRequest;
import software.amazon.awssdk.services.amplify.model.ListJobsResponse;

public class ListJobsIterable
implements SdkIterable<ListJobsResponse> {
    private final AmplifyClient client;
    private final ListJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsIterable(AmplifyClient client, ListJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public Iterator<ListJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobSummaries() {
        Function<ListJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobsResponseFetcher
    implements SyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobsResponse nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsIterable.this.client.listJobs(ListJobsIterable.this.firstRequest);
            }
            return ListJobsIterable.this.client.listJobs((ListJobsRequest)((Object)ListJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

