/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amplify.AmplifyAsyncClient;
import software.amazon.awssdk.services.amplify.AmplifyAsyncClientBuilder;
import software.amazon.awssdk.services.amplify.AmplifyServiceClientConfiguration;
import software.amazon.awssdk.services.amplify.DefaultAmplifyAsyncClient;
import software.amazon.awssdk.services.amplify.DefaultAmplifyBaseClientBuilder;
import software.amazon.awssdk.services.amplify.endpoints.AmplifyEndpointProvider;

@SdkInternalApi
final class DefaultAmplifyAsyncClientBuilder
extends DefaultAmplifyBaseClientBuilder<AmplifyAsyncClientBuilder, AmplifyAsyncClient>
implements AmplifyAsyncClientBuilder {
    DefaultAmplifyAsyncClientBuilder() {
    }

    @Override
    public DefaultAmplifyAsyncClientBuilder endpointProvider(AmplifyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmplifyAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAmplifyAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AmplifyServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAmplifyAsyncClient client = new DefaultAmplifyAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AmplifyServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AmplifyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

