/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendEnvironment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendEnvironment> {
    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backendEnvironmentArn").getter(BackendEnvironment.getter(BackendEnvironment::backendEnvironmentArn)).setter(BackendEnvironment.setter(Builder::backendEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(BackendEnvironment.getter(BackendEnvironment::environmentName)).setter(BackendEnvironment.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackName").getter(BackendEnvironment.getter(BackendEnvironment::stackName)).setter(BackendEnvironment.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentArtifacts").getter(BackendEnvironment.getter(BackendEnvironment::deploymentArtifacts)).setter(BackendEnvironment.setter(Builder::deploymentArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentArtifacts").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(BackendEnvironment.getter(BackendEnvironment::createTime)).setter(BackendEnvironment.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(BackendEnvironment.getter(BackendEnvironment::updateTime)).setter(BackendEnvironment.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENT_ARN_FIELD, ENVIRONMENT_NAME_FIELD, STACK_NAME_FIELD, DEPLOYMENT_ARTIFACTS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backendEnvironmentArn;
    private final String environmentName;
    private final String stackName;
    private final String deploymentArtifacts;
    private final Instant createTime;
    private final Instant updateTime;

    private BackendEnvironment(BuilderImpl builder) {
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
        this.environmentName = builder.environmentName;
        this.stackName = builder.stackName;
        this.deploymentArtifacts = builder.deploymentArtifacts;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String backendEnvironmentArn() {
        return this.backendEnvironmentArn;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String deploymentArtifacts() {
        return this.deploymentArtifacts;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendEnvironment)) {
            return false;
        }
        BackendEnvironment other = (BackendEnvironment)obj;
        return Objects.equals(this.backendEnvironmentArn(), other.backendEnvironmentArn()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.deploymentArtifacts(), other.deploymentArtifacts()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BackendEnvironment").add("BackendEnvironmentArn", (Object)this.backendEnvironmentArn()).add("EnvironmentName", (Object)this.environmentName()).add("StackName", (Object)this.stackName()).add("DeploymentArtifacts", (Object)this.deploymentArtifacts()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "backendEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentArn()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "stackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "deploymentArtifacts": {
                return Optional.ofNullable(clazz.cast(this.deploymentArtifacts()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendEnvironment, T> g) {
        return obj -> g.apply((BackendEnvironment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backendEnvironmentArn;
        private String environmentName;
        private String stackName;
        private String deploymentArtifacts;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendEnvironment model) {
            this.backendEnvironmentArn(model.backendEnvironmentArn);
            this.environmentName(model.environmentName);
            this.stackName(model.stackName);
            this.deploymentArtifacts(model.deploymentArtifacts);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getBackendEnvironmentArn() {
            return this.backendEnvironmentArn;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        @Override
        @Transient
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDeploymentArtifacts() {
            return this.deploymentArtifacts;
        }

        public final void setDeploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
        }

        @Override
        @Transient
        public final Builder deploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        @Transient
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public BackendEnvironment build() {
            return new BackendEnvironment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendEnvironment> {
        public Builder backendEnvironmentArn(String var1);

        public Builder environmentName(String var1);

        public Builder stackName(String var1);

        public Builder deploymentArtifacts(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

