/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.App;
import software.amazon.awssdk.services.amplify.model.AppsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppsResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, ListAppsResponse> {
    private static final SdkField<List<App>> APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("apps").getter(ListAppsResponse.getter(ListAppsResponse::apps)).setter(ListAppsResponse.setter(Builder::apps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(App::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppsResponse.getter(ListAppsResponse::nextToken)).setter(ListAppsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<App> apps;
    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApps() {
        return this.apps != null && !(this.apps instanceof SdkAutoConstructList);
    }

    public final List<App> apps() {
        return this.apps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApps() ? this.apps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse)((Object)obj);
        return this.hasApps() == other.hasApps() && Objects.equals(this.apps(), other.apps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppsResponse").add("Apps", this.hasApps() ? this.apps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apps": {
                return Optional.ofNullable(clazz.cast(this.apps()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private List<App> apps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            this.apps(model.apps);
            this.nextToken(model.nextToken);
        }

        public final List<App.Builder> getApps() {
            List<App.Builder> result = AppsCopier.copyToBuilder(this.apps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App ... apps) {
            this.apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<App.Builder> ... apps) {
            this.apps(Stream.of(apps).map(c -> (App)((App.Builder)App.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<App.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppsResponse> {
        public Builder apps(Collection<App> var1);

        public Builder apps(App ... var1);

        public Builder apps(Consumer<App.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

