/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AutoSubDomainCreationPatternsCopier;
import software.amazon.awssdk.services.amplify.model.DomainStatus;
import software.amazon.awssdk.services.amplify.model.SubDomain;
import software.amazon.awssdk.services.amplify.model.SubDomainsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainAssociation> {
    private static final SdkField<String> DOMAIN_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainAssociationArn").getter(DomainAssociation.getter(DomainAssociation::domainAssociationArn)).setter(DomainAssociation.setter(Builder::domainAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainAssociationArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DomainAssociation.getter(DomainAssociation::domainName)).setter(DomainAssociation.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoSubDomain").getter(DomainAssociation.getter(DomainAssociation::enableAutoSubDomain)).setter(DomainAssociation.setter(Builder::enableAutoSubDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoSubDomain").build()}).build();
    private static final SdkField<List<String>> AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoSubDomainCreationPatterns").getter(DomainAssociation.getter(DomainAssociation::autoSubDomainCreationPatterns)).setter(DomainAssociation.setter(Builder::autoSubDomainCreationPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainCreationPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_SUB_DOMAIN_IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoSubDomainIAMRole").getter(DomainAssociation.getter(DomainAssociation::autoSubDomainIAMRole)).setter(DomainAssociation.setter(Builder::autoSubDomainIAMRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainIAMRole").build()}).build();
    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainStatus").getter(DomainAssociation.getter(DomainAssociation::domainStatusAsString)).setter(DomainAssociation.setter(Builder::domainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainStatus").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DomainAssociation.getter(DomainAssociation::statusReason)).setter(DomainAssociation.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CERTIFICATE_VERIFICATION_DNS_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateVerificationDNSRecord").getter(DomainAssociation.getter(DomainAssociation::certificateVerificationDNSRecord)).setter(DomainAssociation.setter(Builder::certificateVerificationDNSRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateVerificationDNSRecord").build()}).build();
    private static final SdkField<List<SubDomain>> SUB_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subDomains").getter(DomainAssociation.getter(DomainAssociation::subDomains)).setter(DomainAssociation.setter(Builder::subDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ASSOCIATION_ARN_FIELD, DOMAIN_NAME_FIELD, ENABLE_AUTO_SUB_DOMAIN_FIELD, AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD, AUTO_SUB_DOMAIN_IAM_ROLE_FIELD, DOMAIN_STATUS_FIELD, STATUS_REASON_FIELD, CERTIFICATE_VERIFICATION_DNS_RECORD_FIELD, SUB_DOMAINS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainAssociationArn;
    private final String domainName;
    private final Boolean enableAutoSubDomain;
    private final List<String> autoSubDomainCreationPatterns;
    private final String autoSubDomainIAMRole;
    private final String domainStatus;
    private final String statusReason;
    private final String certificateVerificationDNSRecord;
    private final List<SubDomain> subDomains;

    private DomainAssociation(BuilderImpl builder) {
        this.domainAssociationArn = builder.domainAssociationArn;
        this.domainName = builder.domainName;
        this.enableAutoSubDomain = builder.enableAutoSubDomain;
        this.autoSubDomainCreationPatterns = builder.autoSubDomainCreationPatterns;
        this.autoSubDomainIAMRole = builder.autoSubDomainIAMRole;
        this.domainStatus = builder.domainStatus;
        this.statusReason = builder.statusReason;
        this.certificateVerificationDNSRecord = builder.certificateVerificationDNSRecord;
        this.subDomains = builder.subDomains;
    }

    public final String domainAssociationArn() {
        return this.domainAssociationArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Boolean enableAutoSubDomain() {
        return this.enableAutoSubDomain;
    }

    public final boolean hasAutoSubDomainCreationPatterns() {
        return this.autoSubDomainCreationPatterns != null && !(this.autoSubDomainCreationPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> autoSubDomainCreationPatterns() {
        return this.autoSubDomainCreationPatterns;
    }

    public final String autoSubDomainIAMRole() {
        return this.autoSubDomainIAMRole;
    }

    public final DomainStatus domainStatus() {
        return DomainStatus.fromValue(this.domainStatus);
    }

    public final String domainStatusAsString() {
        return this.domainStatus;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String certificateVerificationDNSRecord() {
        return this.certificateVerificationDNSRecord;
    }

    public final boolean hasSubDomains() {
        return this.subDomains != null && !(this.subDomains instanceof SdkAutoConstructList);
    }

    public final List<SubDomain> subDomains() {
        return this.subDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoSubDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoSubDomainCreationPatterns() ? this.autoSubDomainCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSubDomainIAMRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateVerificationDNSRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubDomains() ? this.subDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainAssociation)) {
            return false;
        }
        DomainAssociation other = (DomainAssociation)obj;
        return Objects.equals(this.domainAssociationArn(), other.domainAssociationArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.enableAutoSubDomain(), other.enableAutoSubDomain()) && this.hasAutoSubDomainCreationPatterns() == other.hasAutoSubDomainCreationPatterns() && Objects.equals(this.autoSubDomainCreationPatterns(), other.autoSubDomainCreationPatterns()) && Objects.equals(this.autoSubDomainIAMRole(), other.autoSubDomainIAMRole()) && Objects.equals(this.domainStatusAsString(), other.domainStatusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.certificateVerificationDNSRecord(), other.certificateVerificationDNSRecord()) && this.hasSubDomains() == other.hasSubDomains() && Objects.equals(this.subDomains(), other.subDomains());
    }

    public final String toString() {
        return ToString.builder((String)"DomainAssociation").add("DomainAssociationArn", (Object)this.domainAssociationArn()).add("DomainName", (Object)this.domainName()).add("EnableAutoSubDomain", (Object)this.enableAutoSubDomain()).add("AutoSubDomainCreationPatterns", this.hasAutoSubDomainCreationPatterns() ? this.autoSubDomainCreationPatterns() : null).add("AutoSubDomainIAMRole", (Object)this.autoSubDomainIAMRole()).add("DomainStatus", (Object)this.domainStatusAsString()).add("StatusReason", (Object)this.statusReason()).add("CertificateVerificationDNSRecord", (Object)this.certificateVerificationDNSRecord()).add("SubDomains", this.hasSubDomains() ? this.subDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.domainAssociationArn()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "enableAutoSubDomain": {
                return Optional.ofNullable(clazz.cast(this.enableAutoSubDomain()));
            }
            case "autoSubDomainCreationPatterns": {
                return Optional.ofNullable(clazz.cast(this.autoSubDomainCreationPatterns()));
            }
            case "autoSubDomainIAMRole": {
                return Optional.ofNullable(clazz.cast(this.autoSubDomainIAMRole()));
            }
            case "domainStatus": {
                return Optional.ofNullable(clazz.cast(this.domainStatusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "certificateVerificationDNSRecord": {
                return Optional.ofNullable(clazz.cast(this.certificateVerificationDNSRecord()));
            }
            case "subDomains": {
                return Optional.ofNullable(clazz.cast(this.subDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainAssociation, T> g) {
        return obj -> g.apply((DomainAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainAssociationArn;
        private String domainName;
        private Boolean enableAutoSubDomain;
        private List<String> autoSubDomainCreationPatterns = DefaultSdkAutoConstructList.getInstance();
        private String autoSubDomainIAMRole;
        private String domainStatus;
        private String statusReason;
        private String certificateVerificationDNSRecord;
        private List<SubDomain> subDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainAssociation model) {
            this.domainAssociationArn(model.domainAssociationArn);
            this.domainName(model.domainName);
            this.enableAutoSubDomain(model.enableAutoSubDomain);
            this.autoSubDomainCreationPatterns(model.autoSubDomainCreationPatterns);
            this.autoSubDomainIAMRole(model.autoSubDomainIAMRole);
            this.domainStatus(model.domainStatus);
            this.statusReason(model.statusReason);
            this.certificateVerificationDNSRecord(model.certificateVerificationDNSRecord);
            this.subDomains(model.subDomains);
        }

        public final String getDomainAssociationArn() {
            return this.domainAssociationArn;
        }

        @Override
        public final Builder domainAssociationArn(String domainAssociationArn) {
            this.domainAssociationArn = domainAssociationArn;
            return this;
        }

        public final void setDomainAssociationArn(String domainAssociationArn) {
            this.domainAssociationArn = domainAssociationArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getEnableAutoSubDomain() {
            return this.enableAutoSubDomain;
        }

        @Override
        public final Builder enableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        public final void setEnableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
        }

        public final Collection<String> getAutoSubDomainCreationPatterns() {
            if (this.autoSubDomainCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoSubDomainCreationPatterns;
        }

        @Override
        public final Builder autoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoSubDomainCreationPatterns(String ... autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns(Arrays.asList(autoSubDomainCreationPatterns));
            return this;
        }

        public final void setAutoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
        }

        public final String getAutoSubDomainIAMRole() {
            return this.autoSubDomainIAMRole;
        }

        @Override
        public final Builder autoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
            return this;
        }

        public final void setAutoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
        }

        public final String getDomainStatus() {
            return this.domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getCertificateVerificationDNSRecord() {
            return this.certificateVerificationDNSRecord;
        }

        @Override
        public final Builder certificateVerificationDNSRecord(String certificateVerificationDNSRecord) {
            this.certificateVerificationDNSRecord = certificateVerificationDNSRecord;
            return this;
        }

        public final void setCertificateVerificationDNSRecord(String certificateVerificationDNSRecord) {
            this.certificateVerificationDNSRecord = certificateVerificationDNSRecord;
        }

        public final Collection<SubDomain.Builder> getSubDomains() {
            if (this.subDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subDomains != null ? (Collection)this.subDomains.stream().map(SubDomain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subDomains(Collection<SubDomain> subDomains) {
            this.subDomains = SubDomainsCopier.copy(subDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomains(SubDomain ... subDomains) {
            this.subDomains(Arrays.asList(subDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomains(Consumer<SubDomain.Builder> ... subDomains) {
            this.subDomains(Stream.of(subDomains).map(c -> (SubDomain)((SubDomain.Builder)SubDomain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubDomains(Collection<SubDomain.BuilderImpl> subDomains) {
            this.subDomains = SubDomainsCopier.copyFromBuilder(subDomains);
        }

        public DomainAssociation build() {
            return new DomainAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainAssociation> {
        public Builder domainAssociationArn(String var1);

        public Builder domainName(String var1);

        public Builder enableAutoSubDomain(Boolean var1);

        public Builder autoSubDomainCreationPatterns(Collection<String> var1);

        public Builder autoSubDomainCreationPatterns(String ... var1);

        public Builder autoSubDomainIAMRole(String var1);

        public Builder domainStatus(String var1);

        public Builder domainStatus(DomainStatus var1);

        public Builder statusReason(String var1);

        public Builder certificateVerificationDNSRecord(String var1);

        public Builder subDomains(Collection<SubDomain> var1);

        public Builder subDomains(SubDomain ... var1);

        public Builder subDomains(Consumer<SubDomain.Builder> ... var1);
    }
}

