/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationPatternsCopier;
import software.amazon.awssdk.services.amplify.model.CustomRule;
import software.amazon.awssdk.services.amplify.model.CustomRulesCopier;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Platform;
import software.amazon.awssdk.services.amplify.model.ProductionBranch;
import software.amazon.awssdk.services.amplify.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class App
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, App> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(App.getter(App::appId)).setter(App.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(App.getter(App::appArn)).setter(App.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(App.getter(App::name)).setter(App.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(App.getter(App::tags)).setter(App.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(App.getter(App::description)).setter(App.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(App.getter(App::repository)).setter(App.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(App.getter(App::platformAsString)).setter(App.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(App.getter(App::createTime)).setter(App.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(App.getter(App::updateTime)).setter(App.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamServiceRoleArn").getter(App.getter(App::iamServiceRoleArn)).setter(App.setter(Builder::iamServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(App.getter(App::environmentVariables)).setter(App.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultDomain").getter(App.getter(App::defaultDomain)).setter(App.setter(Builder::defaultDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDomain").build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBranchAutoBuild").getter(App.getter(App::enableBranchAutoBuild)).setter(App.setter(Builder::enableBranchAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBranchAutoDeletion").getter(App.getter(App::enableBranchAutoDeletion)).setter(App.setter(Builder::enableBranchAutoDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBasicAuth").getter(App.getter(App::enableBasicAuth)).setter(App.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basicAuthCredentials").getter(App.getter(App::basicAuthCredentials)).setter(App.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customRules").getter(App.getter(App::customRules)).setter(App.setter(Builder::customRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProductionBranch> PRODUCTION_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("productionBranch").getter(App.getter(App::productionBranch)).setter(App.setter(Builder::productionBranch)).constructor(ProductionBranch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionBranch").build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildSpec").getter(App.getter(App::buildSpec)).setter(App.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<String> CUSTOM_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customHeaders").getter(App.getter(App::customHeaders)).setter(App.setter(Builder::customHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customHeaders").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoBranchCreation").getter(App.getter(App::enableAutoBranchCreation)).setter(App.setter(Builder::enableAutoBranchCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build()}).build();
    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoBranchCreationPatterns").getter(App.getter(App::autoBranchCreationPatterns)).setter(App.setter(Builder::autoBranchCreationPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoBranchCreationConfig").getter(App.getter(App::autoBranchCreationConfig)).setter(App.setter(Builder::autoBranchCreationConfig)).constructor(AutoBranchCreationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD, NAME_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, REPOSITORY_FIELD, PLATFORM_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, ENVIRONMENT_VARIABLES_FIELD, DEFAULT_DOMAIN_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BRANCH_AUTO_DELETION_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, PRODUCTION_BRANCH_FIELD, BUILD_SPEC_FIELD, CUSTOM_HEADERS_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD, AUTO_BRANCH_CREATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appId;
    private final String appArn;
    private final String name;
    private final Map<String, String> tags;
    private final String description;
    private final String repository;
    private final String platform;
    private final Instant createTime;
    private final Instant updateTime;
    private final String iamServiceRoleArn;
    private final Map<String, String> environmentVariables;
    private final String defaultDomain;
    private final Boolean enableBranchAutoBuild;
    private final Boolean enableBranchAutoDeletion;
    private final Boolean enableBasicAuth;
    private final String basicAuthCredentials;
    private final List<CustomRule> customRules;
    private final ProductionBranch productionBranch;
    private final String buildSpec;
    private final String customHeaders;
    private final Boolean enableAutoBranchCreation;
    private final List<String> autoBranchCreationPatterns;
    private final AutoBranchCreationConfig autoBranchCreationConfig;

    private App(BuilderImpl builder) {
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.name = builder.name;
        this.tags = builder.tags;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.environmentVariables = builder.environmentVariables;
        this.defaultDomain = builder.defaultDomain;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.productionBranch = builder.productionBranch;
        this.buildSpec = builder.buildSpec;
        this.customHeaders = builder.customHeaders;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
    }

    public String appId() {
        return this.appId;
    }

    public String appArn() {
        return this.appArn;
    }

    public String name() {
        return this.name;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String description() {
        return this.description;
    }

    public String repository() {
        return this.repository;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public String iamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public String defaultDomain() {
        return this.defaultDomain;
    }

    public Boolean enableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public Boolean enableBranchAutoDeletion() {
        return this.enableBranchAutoDeletion;
    }

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public boolean hasCustomRules() {
        return this.customRules != null && !(this.customRules instanceof SdkAutoConstructList);
    }

    public List<CustomRule> customRules() {
        return this.customRules;
    }

    public ProductionBranch productionBranch() {
        return this.productionBranch;
    }

    public String buildSpec() {
        return this.buildSpec;
    }

    public String customHeaders() {
        return this.customHeaders;
    }

    public Boolean enableAutoBranchCreation() {
        return this.enableAutoBranchCreation;
    }

    public boolean hasAutoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns != null && !(this.autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    public List<String> autoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns;
    }

    public AutoBranchCreationConfig autoBranchCreationConfig() {
        return this.autoBranchCreationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomRules() ? this.customRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.productionBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoBranchCreationPatterns() ? this.autoBranchCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoBranchCreationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.iamServiceRoleArn(), other.iamServiceRoleArn()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.defaultDomain(), other.defaultDomain()) && Objects.equals(this.enableBranchAutoBuild(), other.enableBranchAutoBuild()) && Objects.equals(this.enableBranchAutoDeletion(), other.enableBranchAutoDeletion()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && this.hasCustomRules() == other.hasCustomRules() && Objects.equals(this.customRules(), other.customRules()) && Objects.equals(this.productionBranch(), other.productionBranch()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.customHeaders(), other.customHeaders()) && Objects.equals(this.enableAutoBranchCreation(), other.enableAutoBranchCreation()) && this.hasAutoBranchCreationPatterns() == other.hasAutoBranchCreationPatterns() && Objects.equals(this.autoBranchCreationPatterns(), other.autoBranchCreationPatterns()) && Objects.equals(this.autoBranchCreationConfig(), other.autoBranchCreationConfig());
    }

    public String toString() {
        return ToString.builder((String)"App").add("AppId", (Object)this.appId()).add("AppArn", (Object)this.appArn()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).add("Repository", (Object)this.repository()).add("Platform", (Object)this.platformAsString()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("IamServiceRoleArn", (Object)this.iamServiceRoleArn()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("DefaultDomain", (Object)this.defaultDomain()).add("EnableBranchAutoBuild", (Object)this.enableBranchAutoBuild()).add("EnableBranchAutoDeletion", (Object)this.enableBranchAutoDeletion()).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomRules", this.hasCustomRules() ? this.customRules() : null).add("ProductionBranch", (Object)this.productionBranch()).add("BuildSpec", (Object)this.buildSpec()).add("CustomHeaders", (Object)this.customHeaders()).add("EnableAutoBranchCreation", (Object)this.enableAutoBranchCreation()).add("AutoBranchCreationPatterns", this.hasAutoBranchCreationPatterns() ? this.autoBranchCreationPatterns() : null).add("AutoBranchCreationConfig", (Object)this.autoBranchCreationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "iamServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamServiceRoleArn()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "defaultDomain": {
                return Optional.ofNullable(clazz.cast(this.defaultDomain()));
            }
            case "enableBranchAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoBuild()));
            }
            case "enableBranchAutoDeletion": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoDeletion()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "customRules": {
                return Optional.ofNullable(clazz.cast(this.customRules()));
            }
            case "productionBranch": {
                return Optional.ofNullable(clazz.cast(this.productionBranch()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "customHeaders": {
                return Optional.ofNullable(clazz.cast(this.customHeaders()));
            }
            case "enableAutoBranchCreation": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBranchCreation()));
            }
            case "autoBranchCreationPatterns": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationPatterns()));
            }
            case "autoBranchCreationConfig": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private String appArn;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String repository;
        private String platform;
        private Instant createTime;
        private Instant updateTime;
        private String iamServiceRoleArn;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private String defaultDomain;
        private Boolean enableBranchAutoBuild;
        private Boolean enableBranchAutoDeletion;
        private Boolean enableBasicAuth;
        private String basicAuthCredentials;
        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();
        private ProductionBranch productionBranch;
        private String buildSpec;
        private String customHeaders;
        private Boolean enableAutoBranchCreation;
        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();
        private AutoBranchCreationConfig autoBranchCreationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            this.appId(model.appId);
            this.appArn(model.appArn);
            this.name(model.name);
            this.tags(model.tags);
            this.description(model.description);
            this.repository(model.repository);
            this.platform(model.platform);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.iamServiceRoleArn(model.iamServiceRoleArn);
            this.environmentVariables(model.environmentVariables);
            this.defaultDomain(model.defaultDomain);
            this.enableBranchAutoBuild(model.enableBranchAutoBuild);
            this.enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            this.enableBasicAuth(model.enableBasicAuth);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.customRules(model.customRules);
            this.productionBranch(model.productionBranch);
            this.buildSpec(model.buildSpec);
            this.customHeaders(model.customHeaders);
            this.enableAutoBranchCreation(model.enableAutoBranchCreation);
            this.autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            this.autoBranchCreationConfig(model.autoBranchCreationConfig);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getIamServiceRoleArn() {
            return this.iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final String getDefaultDomain() {
            return this.defaultDomain;
        }

        @Override
        public final Builder defaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
            return this;
        }

        public final void setDefaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return this.enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return this.enableBranchAutoDeletion;
        }

        @Override
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Collection<CustomRule.Builder> getCustomRules() {
            if (this.customRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customRules != null ? (Collection)this.customRules.stream().map(CustomRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule ... customRules) {
            this.customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder> ... customRules) {
            this.customRules(Stream.of(customRules).map(c -> (CustomRule)((CustomRule.Builder)CustomRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        public final ProductionBranch.Builder getProductionBranch() {
            return this.productionBranch != null ? this.productionBranch.toBuilder() : null;
        }

        @Override
        public final Builder productionBranch(ProductionBranch productionBranch) {
            this.productionBranch = productionBranch;
            return this;
        }

        public final void setProductionBranch(ProductionBranch.BuilderImpl productionBranch) {
            this.productionBranch = productionBranch != null ? productionBranch.build() : null;
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final String getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final Builder customHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final void setCustomHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return this.enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            if (this.autoBranchCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoBranchCreationPatterns;
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String ... autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return this.autoBranchCreationConfig != null ? this.autoBranchCreationConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        public App build() {
            return new App(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, App> {
        public Builder appId(String var1);

        public Builder appArn(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder description(String var1);

        public Builder repository(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder iamServiceRoleArn(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder defaultDomain(String var1);

        public Builder enableBranchAutoBuild(Boolean var1);

        public Builder enableBranchAutoDeletion(Boolean var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder basicAuthCredentials(String var1);

        public Builder customRules(Collection<CustomRule> var1);

        public Builder customRules(CustomRule ... var1);

        public Builder customRules(Consumer<CustomRule.Builder> ... var1);

        public Builder productionBranch(ProductionBranch var1);

        default public Builder productionBranch(Consumer<ProductionBranch.Builder> productionBranch) {
            return this.productionBranch((ProductionBranch)((ProductionBranch.Builder)ProductionBranch.builder().applyMutation(productionBranch)).build());
        }

        public Builder buildSpec(String var1);

        public Builder customHeaders(String var1);

        public Builder enableAutoBranchCreation(Boolean var1);

        public Builder autoBranchCreationPatterns(Collection<String> var1);

        public Builder autoBranchCreationPatterns(String ... var1);

        public Builder autoBranchCreationConfig(AutoBranchCreationConfig var1);

        default public Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return this.autoBranchCreationConfig((AutoBranchCreationConfig)((AutoBranchCreationConfig.Builder)AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig)).build());
        }
    }
}

