/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.CustomRule;
import software.amazon.awssdk.services.amplify.model.CustomRulesCopier;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Platform;
import software.amazon.awssdk.services.amplify.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::name)).setter(CreateAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::description)).setter(CreateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::repository)).setter(CreateAppRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::platformAsString)).setter(CreateAppRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::iamServiceRoleArn)).setter(CreateAppRequest.setter(Builder::iamServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()}).build();
    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::oauthToken)).setter(CreateAppRequest.setter(Builder::oauthToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAppRequest.getter(CreateAppRequest::environmentVariables)).setter(CreateAppRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateAppRequest.getter(CreateAppRequest::enableBranchAutoBuild)).setter(CreateAppRequest.setter(Builder::enableBranchAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateAppRequest.getter(CreateAppRequest::enableBasicAuth)).setter(CreateAppRequest.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::basicAuthCredentials)).setter(CreateAppRequest.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAppRequest.getter(CreateAppRequest::customRules)).setter(CreateAppRequest.setter(Builder::customRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAppRequest.getter(CreateAppRequest::tags)).setter(CreateAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAppRequest.getter(CreateAppRequest::buildSpec)).setter(CreateAppRequest.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, REPOSITORY_FIELD, PLATFORM_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, OAUTH_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, TAGS_FIELD, BUILD_SPEC_FIELD));
    private final String name;
    private final String description;
    private final String repository;
    private final String platform;
    private final String iamServiceRoleArn;
    private final String oauthToken;
    private final Map<String, String> environmentVariables;
    private final Boolean enableBranchAutoBuild;
    private final Boolean enableBasicAuth;
    private final String basicAuthCredentials;
    private final List<CustomRule> customRules;
    private final Map<String, String> tags;
    private final String buildSpec;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.oauthToken = builder.oauthToken;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String repository() {
        return this.repository;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String iamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public String oauthToken() {
        return this.oauthToken;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Boolean enableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public List<CustomRule> customRules() {
        return this.customRules;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String buildSpec() {
        return this.buildSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.iamServiceRoleArn(), other.iamServiceRoleArn()) && Objects.equals(this.oauthToken(), other.oauthToken()) && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.enableBranchAutoBuild(), other.enableBranchAutoBuild()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.customRules(), other.customRules()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.buildSpec(), other.buildSpec());
    }

    public String toString() {
        return ToString.builder((String)"CreateAppRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Repository", (Object)this.repository()).add("Platform", (Object)this.platformAsString()).add("IamServiceRoleArn", (Object)this.iamServiceRoleArn()).add("OauthToken", (Object)this.oauthToken()).add("EnvironmentVariables", this.environmentVariables()).add("EnableBranchAutoBuild", (Object)this.enableBranchAutoBuild()).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("BasicAuthCredentials", (Object)this.basicAuthCredentials()).add("CustomRules", this.customRules()).add("Tags", this.tags()).add("BuildSpec", (Object)this.buildSpec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "iamServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamServiceRoleArn()));
            }
            case "oauthToken": {
                return Optional.ofNullable(clazz.cast(this.oauthToken()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "enableBranchAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoBuild()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "customRules": {
                return Optional.ofNullable(clazz.cast(this.customRules()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String repository;
        private String platform;
        private String iamServiceRoleArn;
        private String oauthToken;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enableBranchAutoBuild;
        private Boolean enableBasicAuth;
        private String basicAuthCredentials;
        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String buildSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.repository(model.repository);
            this.platform(model.platform);
            this.iamServiceRoleArn(model.iamServiceRoleArn);
            this.oauthToken(model.oauthToken);
            this.environmentVariables(model.environmentVariables);
            this.enableBranchAutoBuild(model.enableBranchAutoBuild);
            this.enableBasicAuth(model.enableBasicAuth);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.customRules(model.customRules);
            this.tags(model.tags);
            this.buildSpec(model.buildSpec);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getIamServiceRoleArn() {
            return this.iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        public final String getOauthToken() {
            return this.oauthToken;
        }

        @Override
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final Boolean getEnableBranchAutoBuild() {
            return this.enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Collection<CustomRule.Builder> getCustomRules() {
            return this.customRules != null ? (Collection)this.customRules.stream().map(CustomRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule ... customRules) {
            this.customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder> ... customRules) {
            this.customRules(Stream.of(customRules).map(c -> (CustomRule)((CustomRule.Builder)CustomRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder repository(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder iamServiceRoleArn(String var1);

        public Builder oauthToken(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder enableBranchAutoBuild(Boolean var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder basicAuthCredentials(String var1);

        public Builder customRules(Collection<CustomRule> var1);

        public Builder customRules(CustomRule ... var1);

        public Builder customRules(Consumer<CustomRule.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder buildSpec(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

