/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorSummary;
import software.amazon.awssdk.services.amp.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.amp.model.ListAnomalyDetectorsResponse;

public class ListAnomalyDetectorsPublisher
implements SdkPublisher<ListAnomalyDetectorsResponse> {
    private final AmpAsyncClient client;
    private final ListAnomalyDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnomalyDetectorsPublisher(AmpAsyncClient client, ListAnomalyDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnomalyDetectorsPublisher(AmpAsyncClient client, ListAnomalyDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnomalyDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnomalyDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalyDetectorSummary> anomalyDetectors() {
        Function<ListAnomalyDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyDetectors() != null) {
                return response.anomalyDetectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnomalyDetectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnomalyDetectorsResponseFetcher
    implements AsyncPageFetcher<ListAnomalyDetectorsResponse> {
        private ListAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnomalyDetectorsResponse> nextPage(ListAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyDetectorsPublisher.this.client.listAnomalyDetectors(ListAnomalyDetectorsPublisher.this.firstRequest);
            }
            return ListAnomalyDetectorsPublisher.this.client.listAnomalyDetectors((ListAnomalyDetectorsRequest)((Object)ListAnomalyDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

