/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.EksConfiguration;
import software.amazon.awssdk.services.amp.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<EksConfiguration> EKS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksConfiguration").getter(Source.getter(Source::eksConfiguration)).setter(Source.setter(Builder::eksConfiguration)).constructor(EksConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksConfiguration").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(Source.getter(Source::vpcConfiguration)).setter(Source.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Source.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EksConfiguration eksConfiguration;
    private final VpcConfiguration vpcConfiguration;
    private final Type type;

    private Source(BuilderImpl builder) {
        this.eksConfiguration = builder.eksConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.type = builder.type;
    }

    public final EksConfiguration eksConfiguration() {
        return this.eksConfiguration;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.eksConfiguration(), other.eksConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Source").add("EksConfiguration", (Object)this.eksConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksConfiguration": {
                return Optional.ofNullable(clazz.cast(this.eksConfiguration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static Source fromEksConfiguration(EksConfiguration eksConfiguration) {
        return (Source)Source.builder().eksConfiguration(eksConfiguration).build();
    }

    public static Source fromEksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
        EksConfiguration.Builder builder = EksConfiguration.builder();
        eksConfiguration.accept(builder);
        return Source.fromEksConfiguration((EksConfiguration)builder.build());
    }

    public static Source fromVpcConfiguration(VpcConfiguration vpcConfiguration) {
        return (Source)Source.builder().vpcConfiguration(vpcConfiguration).build();
    }

    public static Source fromVpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
        VpcConfiguration.Builder builder = VpcConfiguration.builder();
        vpcConfiguration.accept(builder);
        return Source.fromVpcConfiguration((VpcConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eksConfiguration", EKS_CONFIGURATION_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EKS_CONFIGURATION,
        VPC_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EksConfiguration eksConfiguration;
        private VpcConfiguration vpcConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.eksConfiguration(model.eksConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final EksConfiguration.Builder getEksConfiguration() {
            return this.eksConfiguration != null ? this.eksConfiguration.toBuilder() : null;
        }

        public final void setEksConfiguration(EksConfiguration.BuilderImpl eksConfiguration) {
            EksConfiguration oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration != null ? eksConfiguration.build() : null;
            this.handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
        }

        @Override
        public final Builder eksConfiguration(EksConfiguration eksConfiguration) {
            EksConfiguration oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration;
            this.handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            VpcConfiguration oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
            this.handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            VpcConfiguration oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration;
            this.handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
            return this;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder eksConfiguration(EksConfiguration var1);

        default public Builder eksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
            return this.eksConfiguration((EksConfiguration)((EksConfiguration.Builder)EksConfiguration.builder().applyMutation(eksConfiguration)).build());
        }

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

