/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amp.model.AmpResponse;
import software.amazon.awssdk.services.amp.model.ScraperComponent;
import software.amazon.awssdk.services.amp.model.ScraperComponentsCopier;
import software.amazon.awssdk.services.amp.model.ScraperLoggingConfigurationStatus;
import software.amazon.awssdk.services.amp.model.ScraperLoggingDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScraperLoggingConfigurationResponse
extends AmpResponse
implements ToCopyableBuilder<Builder, DescribeScraperLoggingConfigurationResponse> {
    private static final SdkField<ScraperLoggingConfigurationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(DescribeScraperLoggingConfigurationResponse.getter(DescribeScraperLoggingConfigurationResponse::status)).setter(DescribeScraperLoggingConfigurationResponse.setter(Builder::status)).constructor(ScraperLoggingConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scraperId").getter(DescribeScraperLoggingConfigurationResponse.getter(DescribeScraperLoggingConfigurationResponse::scraperId)).setter(DescribeScraperLoggingConfigurationResponse.setter(Builder::scraperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()}).build();
    private static final SdkField<ScraperLoggingDestination> LOGGING_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingDestination").getter(DescribeScraperLoggingConfigurationResponse.getter(DescribeScraperLoggingConfigurationResponse::loggingDestination)).setter(DescribeScraperLoggingConfigurationResponse.setter(Builder::loggingDestination)).constructor(ScraperLoggingDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingDestination").build()}).build();
    private static final SdkField<List<ScraperComponent>> SCRAPER_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scraperComponents").getter(DescribeScraperLoggingConfigurationResponse.getter(DescribeScraperLoggingConfigurationResponse::scraperComponents)).setter(DescribeScraperLoggingConfigurationResponse.setter(Builder::scraperComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScraperComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(DescribeScraperLoggingConfigurationResponse.getter(DescribeScraperLoggingConfigurationResponse::modifiedAt)).setter(DescribeScraperLoggingConfigurationResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SCRAPER_ID_FIELD, LOGGING_DESTINATION_FIELD, SCRAPER_COMPONENTS_FIELD, MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScraperLoggingConfigurationResponse.memberNameToFieldInitializer();
    private final ScraperLoggingConfigurationStatus status;
    private final String scraperId;
    private final ScraperLoggingDestination loggingDestination;
    private final List<ScraperComponent> scraperComponents;
    private final Instant modifiedAt;

    private DescribeScraperLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.scraperId = builder.scraperId;
        this.loggingDestination = builder.loggingDestination;
        this.scraperComponents = builder.scraperComponents;
        this.modifiedAt = builder.modifiedAt;
    }

    public final ScraperLoggingConfigurationStatus status() {
        return this.status;
    }

    public final String scraperId() {
        return this.scraperId;
    }

    public final ScraperLoggingDestination loggingDestination() {
        return this.loggingDestination;
    }

    public final boolean hasScraperComponents() {
        return this.scraperComponents != null && !(this.scraperComponents instanceof SdkAutoConstructList);
    }

    public final List<ScraperComponent> scraperComponents() {
        return this.scraperComponents;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScraperComponents() ? this.scraperComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScraperLoggingConfigurationResponse)) {
            return false;
        }
        DescribeScraperLoggingConfigurationResponse other = (DescribeScraperLoggingConfigurationResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.scraperId(), other.scraperId()) && Objects.equals(this.loggingDestination(), other.loggingDestination()) && this.hasScraperComponents() == other.hasScraperComponents() && Objects.equals(this.scraperComponents(), other.scraperComponents()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScraperLoggingConfigurationResponse").add("Status", (Object)this.status()).add("ScraperId", (Object)this.scraperId()).add("LoggingDestination", (Object)this.loggingDestination()).add("ScraperComponents", this.hasScraperComponents() ? this.scraperComponents() : null).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "scraperId": {
                return Optional.ofNullable(clazz.cast(this.scraperId()));
            }
            case "loggingDestination": {
                return Optional.ofNullable(clazz.cast(this.loggingDestination()));
            }
            case "scraperComponents": {
                return Optional.ofNullable(clazz.cast(this.scraperComponents()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        map.put("loggingDestination", LOGGING_DESTINATION_FIELD);
        map.put("scraperComponents", SCRAPER_COMPONENTS_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScraperLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeScraperLoggingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpResponse.BuilderImpl
    implements Builder {
        private ScraperLoggingConfigurationStatus status;
        private String scraperId;
        private ScraperLoggingDestination loggingDestination;
        private List<ScraperComponent> scraperComponents = DefaultSdkAutoConstructList.getInstance();
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScraperLoggingConfigurationResponse model) {
            super(model);
            this.status(model.status);
            this.scraperId(model.scraperId);
            this.loggingDestination(model.loggingDestination);
            this.scraperComponents(model.scraperComponents);
            this.modifiedAt(model.modifiedAt);
        }

        public final ScraperLoggingConfigurationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ScraperLoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperLoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getScraperId() {
            return this.scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final ScraperLoggingDestination.Builder getLoggingDestination() {
            return this.loggingDestination != null ? this.loggingDestination.toBuilder() : null;
        }

        public final void setLoggingDestination(ScraperLoggingDestination.BuilderImpl loggingDestination) {
            this.loggingDestination = loggingDestination != null ? loggingDestination.build() : null;
        }

        @Override
        public final Builder loggingDestination(ScraperLoggingDestination loggingDestination) {
            this.loggingDestination = loggingDestination;
            return this;
        }

        public final List<ScraperComponent.Builder> getScraperComponents() {
            List<ScraperComponent.Builder> result = ScraperComponentsCopier.copyToBuilder(this.scraperComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScraperComponents(Collection<ScraperComponent.BuilderImpl> scraperComponents) {
            this.scraperComponents = ScraperComponentsCopier.copyFromBuilder(scraperComponents);
        }

        @Override
        public final Builder scraperComponents(Collection<ScraperComponent> scraperComponents) {
            this.scraperComponents = ScraperComponentsCopier.copy(scraperComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scraperComponents(ScraperComponent ... scraperComponents) {
            this.scraperComponents(Arrays.asList(scraperComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scraperComponents(Consumer<ScraperComponent.Builder> ... scraperComponents) {
            this.scraperComponents(Stream.of(scraperComponents).map(c -> (ScraperComponent)((ScraperComponent.Builder)ScraperComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public DescribeScraperLoggingConfigurationResponse build() {
            return new DescribeScraperLoggingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScraperLoggingConfigurationResponse> {
        public Builder status(ScraperLoggingConfigurationStatus var1);

        default public Builder status(Consumer<ScraperLoggingConfigurationStatus.Builder> status) {
            return this.status((ScraperLoggingConfigurationStatus)((ScraperLoggingConfigurationStatus.Builder)ScraperLoggingConfigurationStatus.builder().applyMutation(status)).build());
        }

        public Builder scraperId(String var1);

        public Builder loggingDestination(ScraperLoggingDestination var1);

        default public Builder loggingDestination(Consumer<ScraperLoggingDestination.Builder> loggingDestination) {
            return this.loggingDestination((ScraperLoggingDestination)((ScraperLoggingDestination.Builder)ScraperLoggingDestination.builder().applyMutation(loggingDestination)).build());
        }

        public Builder scraperComponents(Collection<ScraperComponent> var1);

        public Builder scraperComponents(ScraperComponent ... var1);

        public Builder scraperComponents(Consumer<ScraperComponent.Builder> ... var1);

        public Builder modifiedAt(Instant var1);
    }
}

