/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceConfigurationResponse extends AmpResponse implements
        ToCopyableBuilder<UpdateWorkspaceConfigurationResponse.Builder, UpdateWorkspaceConfigurationResponse> {
    private static final SdkField<WorkspaceConfigurationStatus> STATUS_FIELD = SdkField
            .<WorkspaceConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(UpdateWorkspaceConfigurationResponse::status)).setter(setter(Builder::status))
            .constructor(WorkspaceConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspaceConfigurationStatus status;

    private UpdateWorkspaceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * The status of the workspace configuration.
     * </p>
     * 
     * @return The status of the workspace configuration.
     */
    public final WorkspaceConfigurationStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceConfigurationResponse)) {
            return false;
        }
        UpdateWorkspaceConfigurationResponse other = (UpdateWorkspaceConfigurationResponse) obj;
        return Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceConfigurationResponse").add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateWorkspaceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspaceConfigurationResponse> {
        /**
         * <p>
         * The status of the workspace configuration.
         * </p>
         * 
         * @param status
         *        The status of the workspace configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(WorkspaceConfigurationStatus status);

        /**
         * <p>
         * The status of the workspace configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceConfigurationStatus.Builder}
         * avoiding the need to create one manually via {@link WorkspaceConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceConfigurationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(WorkspaceConfigurationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link WorkspaceConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(WorkspaceConfigurationStatus)
         */
        default Builder status(Consumer<WorkspaceConfigurationStatus.Builder> status) {
            return status(WorkspaceConfigurationStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private WorkspaceConfigurationStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceConfigurationResponse model) {
            super(model);
            status(model.status);
        }

        public final WorkspaceConfigurationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(WorkspaceConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(WorkspaceConfigurationStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateWorkspaceConfigurationResponse build() {
            return new UpdateWorkspaceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
