/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceConfigurationRequest extends AmpRequest implements
        ToCopyableBuilder<UpdateWorkspaceConfigurationRequest.Builder, UpdateWorkspaceConfigurationRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateWorkspaceConfigurationRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateWorkspaceConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<LimitsPerLabelSet>> LIMITS_PER_LABEL_SET_FIELD = SdkField
            .<List<LimitsPerLabelSet>> builder(MarshallingType.LIST)
            .memberName("limitsPerLabelSet")
            .getter(getter(UpdateWorkspaceConfigurationRequest::limitsPerLabelSet))
            .setter(setter(Builder::limitsPerLabelSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitsPerLabelSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LimitsPerLabelSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(LimitsPerLabelSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriodInDays").getter(getter(UpdateWorkspaceConfigurationRequest::retentionPeriodInDays))
            .setter(setter(Builder::retentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriodInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            CLIENT_TOKEN_FIELD, LIMITS_PER_LABEL_SET_FIELD, RETENTION_PERIOD_IN_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String clientToken;

    private final List<LimitsPerLabelSet> limitsPerLabelSet;

    private final Integer retentionPeriodInDays;

    private UpdateWorkspaceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.clientToken = builder.clientToken;
        this.limitsPerLabelSet = builder.limitsPerLabelSet;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    /**
     * <p>
     * The ID of the workspace that you want to update. To find the IDs of your workspaces, use the <a
     * href="https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListWorkspaces.htm">ListWorkspaces</a>
     * operation.
     * </p>
     * 
     * @return The ID of the workspace that you want to update. To find the IDs of your workspaces, use the <a
     *         href="https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListWorkspaces.htm"
     *         >ListWorkspaces</a> operation.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * You can include a token in your operation to make it an idempotent opeartion.
     * </p>
     * 
     * @return You can include a token in your operation to make it an idempotent opeartion.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LimitsPerLabelSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLimitsPerLabelSet() {
        return limitsPerLabelSet != null && !(limitsPerLabelSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is an array of structures, where each structure defines a label set for the workspace, and defines the
     * active time series limit for each of those label sets. Each label name in a label set must be unique.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLimitsPerLabelSet} method.
     * </p>
     * 
     * @return This is an array of structures, where each structure defines a label set for the workspace, and defines
     *         the active time series limit for each of those label sets. Each label name in a label set must be unique.
     */
    public final List<LimitsPerLabelSet> limitsPerLabelSet() {
        return limitsPerLabelSet;
    }

    /**
     * <p>
     * Specifies how many days that metrics will be retained in the workspace.
     * </p>
     * 
     * @return Specifies how many days that metrics will be retained in the workspace.
     */
    public final Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasLimitsPerLabelSet() ? limitsPerLabelSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceConfigurationRequest)) {
            return false;
        }
        UpdateWorkspaceConfigurationRequest other = (UpdateWorkspaceConfigurationRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(clientToken(), other.clientToken())
                && hasLimitsPerLabelSet() == other.hasLimitsPerLabelSet()
                && Objects.equals(limitsPerLabelSet(), other.limitsPerLabelSet())
                && Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceConfigurationRequest").add("WorkspaceId", workspaceId())
                .add("ClientToken", clientToken()).add("LimitsPerLabelSet", hasLimitsPerLabelSet() ? limitsPerLabelSet() : null)
                .add("RetentionPeriodInDays", retentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "limitsPerLabelSet":
            return Optional.ofNullable(clazz.cast(limitsPerLabelSet()));
        case "retentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("limitsPerLabelSet", LIMITS_PER_LABEL_SET_FIELD);
        map.put("retentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspaceConfigurationRequest> {
        /**
         * <p>
         * The ID of the workspace that you want to update. To find the IDs of your workspaces, use the <a
         * href="https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListWorkspaces.htm">ListWorkspaces</a>
         * operation.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that you want to update. To find the IDs of your workspaces, use the <a
         *        href="https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListWorkspaces.htm"
         *        >ListWorkspaces</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * You can include a token in your operation to make it an idempotent opeartion.
         * </p>
         * 
         * @param clientToken
         *        You can include a token in your operation to make it an idempotent opeartion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * This is an array of structures, where each structure defines a label set for the workspace, and defines the
         * active time series limit for each of those label sets. Each label name in a label set must be unique.
         * </p>
         * 
         * @param limitsPerLabelSet
         *        This is an array of structures, where each structure defines a label set for the workspace, and
         *        defines the active time series limit for each of those label sets. Each label name in a label set must
         *        be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet);

        /**
         * <p>
         * This is an array of structures, where each structure defines a label set for the workspace, and defines the
         * active time series limit for each of those label sets. Each label name in a label set must be unique.
         * </p>
         * 
         * @param limitsPerLabelSet
         *        This is an array of structures, where each structure defines a label set for the workspace, and
         *        defines the active time series limit for each of those label sets. Each label name in a label set must
         *        be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitsPerLabelSet(LimitsPerLabelSet... limitsPerLabelSet);

        /**
         * <p>
         * This is an array of structures, where each structure defines a label set for the workspace, and defines the
         * active time series limit for each of those label sets. Each label name in a label set must be unique.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder#build()} is called immediately and
         * its result is passed to {@link #limitsPerLabelSet(List<LimitsPerLabelSet>)}.
         * 
         * @param limitsPerLabelSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limitsPerLabelSet(java.util.Collection<LimitsPerLabelSet>)
         */
        Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder>... limitsPerLabelSet);

        /**
         * <p>
         * Specifies how many days that metrics will be retained in the workspace.
         * </p>
         * 
         * @param retentionPeriodInDays
         *        Specifies how many days that metrics will be retained in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String clientToken;

        private List<LimitsPerLabelSet> limitsPerLabelSet = DefaultSdkAutoConstructList.getInstance();

        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceConfigurationRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            clientToken(model.clientToken);
            limitsPerLabelSet(model.limitsPerLabelSet);
            retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<LimitsPerLabelSet.Builder> getLimitsPerLabelSet() {
            List<LimitsPerLabelSet.Builder> result = LimitsPerLabelSetListCopier.copyToBuilder(this.limitsPerLabelSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimitsPerLabelSet(Collection<LimitsPerLabelSet.BuilderImpl> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copyFromBuilder(limitsPerLabelSet);
        }

        @Override
        public final Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copy(limitsPerLabelSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(LimitsPerLabelSet... limitsPerLabelSet) {
            limitsPerLabelSet(Arrays.asList(limitsPerLabelSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder>... limitsPerLabelSet) {
            limitsPerLabelSet(Stream.of(limitsPerLabelSet).map(c -> LimitsPerLabelSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceConfigurationRequest build() {
            return new UpdateWorkspaceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
