/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of collected metrics for a scraper.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<EksConfiguration> EKS_CONFIGURATION_FIELD = SdkField
            .<EksConfiguration> builder(MarshallingType.SDK_POJO).memberName("eksConfiguration")
            .getter(getter(Source::eksConfiguration)).setter(setter(Builder::eksConfiguration))
            .constructor(EksConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksConfiguration").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(Source::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CONFIGURATION_FIELD,
            VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EksConfiguration eksConfiguration;

    private final VpcConfiguration vpcConfiguration;

    private final Type type;

    private Source(BuilderImpl builder) {
        this.eksConfiguration = builder.eksConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @return The Amazon EKS cluster from which a scraper collects metrics.
     */
    public final EksConfiguration eksConfiguration() {
        return eksConfiguration;
    }

    /**
     * <p>
     * The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     * configuration enables secure, private network connectivity between the collector and your Amazon MSK cluster
     * within your Amazon VPC.
     * </p>
     * 
     * @return The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     *         configuration enables secure, private network connectivity between the collector and your Amazon MSK
     *         cluster within your Amazon VPC.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(eksConfiguration(), other.eksConfiguration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("EksConfiguration", eksConfiguration()).add("VpcConfiguration", vpcConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksConfiguration":
            return Optional.ofNullable(clazz.cast(eksConfiguration()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #eksConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @param eksConfiguration
     *        The Amazon EKS cluster from which a scraper collects metrics.
     */
    public static Source fromEksConfiguration(EksConfiguration eksConfiguration) {
        return builder().eksConfiguration(eksConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #eksConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon EKS cluster from which a scraper collects metrics.
     * </p>
     * 
     * @param eksConfiguration
     *        The Amazon EKS cluster from which a scraper collects metrics.
     */
    public static Source fromEksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
        EksConfiguration.Builder builder = EksConfiguration.builder();
        eksConfiguration.accept(builder);
        return fromEksConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #vpcConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     * configuration enables secure, private network connectivity between the collector and your Amazon MSK cluster
     * within your Amazon VPC.
     * </p>
     * 
     * @param vpcConfiguration
     *        The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     *        configuration enables secure, private network connectivity between the collector and your Amazon MSK
     *        cluster within your Amazon VPC.
     */
    public static Source fromVpcConfiguration(VpcConfiguration vpcConfiguration) {
        return builder().vpcConfiguration(vpcConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #vpcConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     * configuration enables secure, private network connectivity between the collector and your Amazon MSK cluster
     * within your Amazon VPC.
     * </p>
     * 
     * @param vpcConfiguration
     *        The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
     *        configuration enables secure, private network connectivity between the collector and your Amazon MSK
     *        cluster within your Amazon VPC.
     */
    public static Source fromVpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
        VpcConfiguration.Builder builder = VpcConfiguration.builder();
        vpcConfiguration.accept(builder);
        return fromVpcConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eksConfiguration", EKS_CONFIGURATION_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The Amazon EKS cluster from which a scraper collects metrics.
         * </p>
         * 
         * @param eksConfiguration
         *        The Amazon EKS cluster from which a scraper collects metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksConfiguration(EksConfiguration eksConfiguration);

        /**
         * <p>
         * The Amazon EKS cluster from which a scraper collects metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksConfiguration.Builder} avoiding the
         * need to create one manually via {@link EksConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #eksConfiguration(EksConfiguration)}.
         * 
         * @param eksConfiguration
         *        a consumer that will call methods on {@link EksConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksConfiguration(EksConfiguration)
         */
        default Builder eksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
            return eksConfiguration(EksConfiguration.builder().applyMutation(eksConfiguration).build());
        }

        /**
         * <p>
         * The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
         * configuration enables secure, private network connectivity between the collector and your Amazon MSK cluster
         * within your Amazon VPC.
         * </p>
         * 
         * @param vpcConfiguration
         *        The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
         *        configuration enables secure, private network connectivity between the collector and your Amazon MSK
         *        cluster within your Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The Amazon VPC configuration for the Prometheus collector when connecting to Amazon MSK clusters. This
         * configuration enables secure, private network connectivity between the collector and your Amazon MSK cluster
         * within your Amazon VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EksConfiguration eksConfiguration;

        private VpcConfiguration vpcConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            eksConfiguration(model.eksConfiguration);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final EksConfiguration.Builder getEksConfiguration() {
            return eksConfiguration != null ? eksConfiguration.toBuilder() : null;
        }

        public final void setEksConfiguration(EksConfiguration.BuilderImpl eksConfiguration) {
            Object oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration != null ? eksConfiguration.build() : null;
            handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
        }

        @Override
        public final Builder eksConfiguration(EksConfiguration eksConfiguration) {
            Object oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration;
            handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            Object oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
            handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            Object oldValue = this.vpcConfiguration;
            this.vpcConfiguration = vpcConfiguration;
            handleUnionValueChange(Type.VPC_CONFIGURATION, oldValue, this.vpcConfiguration);
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Source#type()
     */
    public enum Type {
        EKS_CONFIGURATION,

        VPC_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
