/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A component of a Amazon Managed Service for Prometheus scraper that can be configured for logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScraperComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<ScraperComponent.Builder, ScraperComponent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ScraperComponent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ComponentConfig> CONFIG_FIELD = SdkField.<ComponentConfig> builder(MarshallingType.SDK_POJO)
            .memberName("config").getter(getter(ScraperComponent::config)).setter(setter(Builder::config))
            .constructor(ComponentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final ComponentConfig config;

    private ScraperComponent(BuilderImpl builder) {
        this.type = builder.type;
        this.config = builder.config;
    }

    /**
     * <p>
     * The type of the scraper component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ScraperComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the scraper component.
     * @see ScraperComponentType
     */
    public final ScraperComponentType type() {
        return ScraperComponentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the scraper component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ScraperComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the scraper component.
     * @see ScraperComponentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration settings for the scraper component.
     * </p>
     * 
     * @return The configuration settings for the scraper component.
     */
    public final ComponentConfig config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScraperComponent)) {
            return false;
        }
        ScraperComponent other = (ScraperComponent) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScraperComponent").add("Type", typeAsString()).add("Config", config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("config", CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScraperComponent, T> g) {
        return obj -> g.apply((ScraperComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScraperComponent> {
        /**
         * <p>
         * The type of the scraper component.
         * </p>
         * 
         * @param type
         *        The type of the scraper component.
         * @see ScraperComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScraperComponentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the scraper component.
         * </p>
         * 
         * @param type
         *        The type of the scraper component.
         * @see ScraperComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScraperComponentType
         */
        Builder type(ScraperComponentType type);

        /**
         * <p>
         * The configuration settings for the scraper component.
         * </p>
         * 
         * @param config
         *        The configuration settings for the scraper component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(ComponentConfig config);

        /**
         * <p>
         * The configuration settings for the scraper component.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentConfig.Builder} avoiding the
         * need to create one manually via {@link ComponentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(ComponentConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link ComponentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(ComponentConfig)
         */
        default Builder config(Consumer<ComponentConfig.Builder> config) {
            return config(ComponentConfig.builder().applyMutation(config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ComponentConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(ScraperComponent model) {
            type(model.type);
            config(model.config);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ScraperComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ComponentConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(ComponentConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(ComponentConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public ScraperComponent build() {
            return new ScraperComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
