/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyResponse extends AmpResponse implements
        ToCopyableBuilder<PutResourcePolicyResponse.Builder, PutResourcePolicyResponse> {
    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStatus").getter(getter(PutResourcePolicyResponse::policyStatusAsString))
            .setter(setter(Builder::policyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStatus").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(PutResourcePolicyResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STATUS_FIELD,
            REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStatus;

    private final String revisionId;

    private PutResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyStatus = builder.policyStatus;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The current status of the resource-based policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link WorkspacePolicyStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return The current status of the resource-based policy.
     * @see WorkspacePolicyStatusCode
     */
    public final WorkspacePolicyStatusCode policyStatus() {
        return WorkspacePolicyStatusCode.fromValue(policyStatus);
    }

    /**
     * <p>
     * The current status of the resource-based policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link WorkspacePolicyStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return The current status of the resource-based policy.
     * @see WorkspacePolicyStatusCode
     */
    public final String policyStatusAsString() {
        return policyStatus;
    }

    /**
     * <p>
     * The revision ID of the newly created or updated resource-based policy.
     * </p>
     * 
     * @return The revision ID of the newly created or updated resource-based policy.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyResponse)) {
            return false;
        }
        PutResourcePolicyResponse other = (PutResourcePolicyResponse) obj;
        return Objects.equals(policyStatusAsString(), other.policyStatusAsString())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyResponse").add("PolicyStatus", policyStatusAsString())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStatus":
            return Optional.ofNullable(clazz.cast(policyStatusAsString()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStatus", POLICY_STATUS_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyResponse, T> g) {
        return obj -> g.apply((PutResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyResponse> {
        /**
         * <p>
         * The current status of the resource-based policy.
         * </p>
         * 
         * @param policyStatus
         *        The current status of the resource-based policy.
         * @see WorkspacePolicyStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspacePolicyStatusCode
         */
        Builder policyStatus(String policyStatus);

        /**
         * <p>
         * The current status of the resource-based policy.
         * </p>
         * 
         * @param policyStatus
         *        The current status of the resource-based policy.
         * @see WorkspacePolicyStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspacePolicyStatusCode
         */
        Builder policyStatus(WorkspacePolicyStatusCode policyStatus);

        /**
         * <p>
         * The revision ID of the newly created or updated resource-based policy.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the newly created or updated resource-based policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private String policyStatus;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyResponse model) {
            super(model);
            policyStatus(model.policyStatus);
            revisionId(model.revisionId);
        }

        public final String getPolicyStatus() {
            return policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(WorkspacePolicyStatusCode policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public PutResourcePolicyResponse build() {
            return new PutResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
