/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Where to send the metrics from a scraper.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<AmpConfiguration> AMP_CONFIGURATION_FIELD = SdkField
            .<AmpConfiguration> builder(MarshallingType.SDK_POJO).memberName("ampConfiguration")
            .getter(getter(Destination::ampConfiguration)).setter(setter(Builder::ampConfiguration))
            .constructor(AmpConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ampConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMP_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AmpConfiguration ampConfiguration;

    private final Type type;

    private Destination(BuilderImpl builder) {
        this.ampConfiguration = builder.ampConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @return The Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public final AmpConfiguration ampConfiguration() {
        return ampConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ampConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(ampConfiguration(), other.ampConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("AmpConfiguration", ampConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ampConfiguration":
            return Optional.ofNullable(clazz.cast(ampConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ampConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @param ampConfiguration
     *        The Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public static Destination fromAmpConfiguration(AmpConfiguration ampConfiguration) {
        return builder().ampConfiguration(ampConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #ampConfiguration()} initialized to the given value.
     *
     * <p>
     * The Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @param ampConfiguration
     *        The Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public static Destination fromAmpConfiguration(Consumer<AmpConfiguration.Builder> ampConfiguration) {
        AmpConfiguration.Builder builder = AmpConfiguration.builder();
        ampConfiguration.accept(builder);
        return fromAmpConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ampConfiguration", AMP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * 
         * @param ampConfiguration
         *        The Amazon Managed Service for Prometheus workspace to send metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ampConfiguration(AmpConfiguration ampConfiguration);

        /**
         * <p>
         * The Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmpConfiguration.Builder} avoiding the
         * need to create one manually via {@link AmpConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmpConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #ampConfiguration(AmpConfiguration)}.
         * 
         * @param ampConfiguration
         *        a consumer that will call methods on {@link AmpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ampConfiguration(AmpConfiguration)
         */
        default Builder ampConfiguration(Consumer<AmpConfiguration.Builder> ampConfiguration) {
            return ampConfiguration(AmpConfiguration.builder().applyMutation(ampConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmpConfiguration ampConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            ampConfiguration(model.ampConfiguration);
        }

        public final AmpConfiguration.Builder getAmpConfiguration() {
            return ampConfiguration != null ? ampConfiguration.toBuilder() : null;
        }

        public final void setAmpConfiguration(AmpConfiguration.BuilderImpl ampConfiguration) {
            Object oldValue = this.ampConfiguration;
            this.ampConfiguration = ampConfiguration != null ? ampConfiguration.build() : null;
            handleUnionValueChange(Type.AMP_CONFIGURATION, oldValue, this.ampConfiguration);
        }

        @Override
        public final Builder ampConfiguration(AmpConfiguration ampConfiguration) {
            Object oldValue = this.ampConfiguration;
            this.ampConfiguration = ampConfiguration;
            handleUnionValueChange(Type.AMP_CONFIGURATION, oldValue, this.ampConfiguration);
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Destination#type()
     */
    public enum Type {
        AMP_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
