/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceConfigurationResponse extends AmpResponse implements
        ToCopyableBuilder<DescribeWorkspaceConfigurationResponse.Builder, DescribeWorkspaceConfigurationResponse> {
    private static final SdkField<WorkspaceConfigurationDescription> WORKSPACE_CONFIGURATION_FIELD = SdkField
            .<WorkspaceConfigurationDescription> builder(MarshallingType.SDK_POJO).memberName("workspaceConfiguration")
            .getter(getter(DescribeWorkspaceConfigurationResponse::workspaceConfiguration))
            .setter(setter(Builder::workspaceConfiguration)).constructor(WorkspaceConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(WORKSPACE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspaceConfigurationDescription workspaceConfiguration;

    private DescribeWorkspaceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceConfiguration = builder.workspaceConfiguration;
    }

    /**
     * <p>
     * This structure contains the information about the workspace configuration.
     * </p>
     * 
     * @return This structure contains the information about the workspace configuration.
     */
    public final WorkspaceConfigurationDescription workspaceConfiguration() {
        return workspaceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceConfigurationResponse)) {
            return false;
        }
        DescribeWorkspaceConfigurationResponse other = (DescribeWorkspaceConfigurationResponse) obj;
        return Objects.equals(workspaceConfiguration(), other.workspaceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceConfigurationResponse").add("WorkspaceConfiguration", workspaceConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceConfiguration":
            return Optional.ofNullable(clazz.cast(workspaceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceConfiguration", WORKSPACE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceConfigurationResponse> {
        /**
         * <p>
         * This structure contains the information about the workspace configuration.
         * </p>
         * 
         * @param workspaceConfiguration
         *        This structure contains the information about the workspace configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceConfiguration(WorkspaceConfigurationDescription workspaceConfiguration);

        /**
         * <p>
         * This structure contains the information about the workspace configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkspaceConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link WorkspaceConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #workspaceConfiguration(WorkspaceConfigurationDescription)}.
         * 
         * @param workspaceConfiguration
         *        a consumer that will call methods on {@link WorkspaceConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceConfiguration(WorkspaceConfigurationDescription)
         */
        default Builder workspaceConfiguration(Consumer<WorkspaceConfigurationDescription.Builder> workspaceConfiguration) {
            return workspaceConfiguration(WorkspaceConfigurationDescription.builder().applyMutation(workspaceConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private WorkspaceConfigurationDescription workspaceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceConfigurationResponse model) {
            super(model);
            workspaceConfiguration(model.workspaceConfiguration);
        }

        public final WorkspaceConfigurationDescription.Builder getWorkspaceConfiguration() {
            return workspaceConfiguration != null ? workspaceConfiguration.toBuilder() : null;
        }

        public final void setWorkspaceConfiguration(WorkspaceConfigurationDescription.BuilderImpl workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration != null ? workspaceConfiguration.build() : null;
        }

        @Override
        public final Builder workspaceConfiguration(WorkspaceConfigurationDescription workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration;
            return this;
        }

        @Override
        public DescribeWorkspaceConfigurationResponse build() {
            return new DescribeWorkspaceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
