/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalyDetectorResponse extends AmpResponse implements
        ToCopyableBuilder<CreateAnomalyDetectorResponse.Builder, CreateAnomalyDetectorResponse> {
    private static final SdkField<String> ANOMALY_DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorId").getter(getter(CreateAnomalyDetectorResponse::anomalyDetectorId))
            .setter(setter(Builder::anomalyDetectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateAnomalyDetectorResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<AnomalyDetectorStatus> STATUS_FIELD = SdkField
            .<AnomalyDetectorStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(CreateAnomalyDetectorResponse::status)).setter(setter(Builder::status))
            .constructor(AnomalyDetectorStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAnomalyDetectorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ID_FIELD,
            ARN_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anomalyDetectorId;

    private final String arn;

    private final AnomalyDetectorStatus status;

    private final Map<String, String> tags;

    private CreateAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorId = builder.anomalyDetectorId;
        this.arn = builder.arn;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the created anomaly detector.
     * </p>
     * 
     * @return The unique identifier of the created anomaly detector.
     */
    public final String anomalyDetectorId() {
        return anomalyDetectorId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created anomaly detector.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status information of the created anomaly detector.
     * </p>
     * 
     * @return The status information of the created anomaly detector.
     */
    public final AnomalyDetectorStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags applied to the created anomaly detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags applied to the created anomaly detector.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyDetectorResponse)) {
            return false;
        }
        CreateAnomalyDetectorResponse other = (CreateAnomalyDetectorResponse) obj;
        return Objects.equals(anomalyDetectorId(), other.anomalyDetectorId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(status(), other.status()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalyDetectorResponse").add("AnomalyDetectorId", anomalyDetectorId()).add("Arn", arn())
                .add("Status", status()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyDetectorId":
            return Optional.ofNullable(clazz.cast(anomalyDetectorId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anomalyDetectorId", ANOMALY_DETECTOR_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((CreateAnomalyDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnomalyDetectorResponse> {
        /**
         * <p>
         * The unique identifier of the created anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorId
         *        The unique identifier of the created anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorId(String anomalyDetectorId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created anomaly detector.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the created anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status information of the created anomaly detector.
         * </p>
         * 
         * @param status
         *        The status information of the created anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AnomalyDetectorStatus status);

        /**
         * <p>
         * The status information of the created anomaly detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorStatus.Builder} avoiding
         * the need to create one manually via {@link AnomalyDetectorStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(AnomalyDetectorStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AnomalyDetectorStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AnomalyDetectorStatus)
         */
        default Builder status(Consumer<AnomalyDetectorStatus.Builder> status) {
            return status(AnomalyDetectorStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The tags applied to the created anomaly detector.
         * </p>
         * 
         * @param tags
         *        The tags applied to the created anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private String anomalyDetectorId;

        private String arn;

        private AnomalyDetectorStatus status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyDetectorResponse model) {
            super(model);
            anomalyDetectorId(model.anomalyDetectorId);
            arn(model.arn);
            status(model.status);
            tags(model.tags);
        }

        public final String getAnomalyDetectorId() {
            return anomalyDetectorId;
        }

        public final void setAnomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
        }

        @Override
        public final Builder anomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AnomalyDetectorStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AnomalyDetectorStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AnomalyDetectorStatus status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateAnomalyDetectorResponse build() {
            return new CreateAnomalyDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
