/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalyDetectorRequest extends AmpRequest implements
        ToCopyableBuilder<CreateAnomalyDetectorRequest.Builder, CreateAnomalyDetectorRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateAnomalyDetectorRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(CreateAnomalyDetectorRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<Integer> EVALUATION_INTERVAL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evaluationIntervalInSeconds")
            .getter(getter(CreateAnomalyDetectorRequest::evaluationIntervalInSeconds))
            .setter(setter(Builder::evaluationIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationIntervalInSeconds")
                    .build()).build();

    private static final SdkField<AnomalyDetectorMissingDataAction> MISSING_DATA_ACTION_FIELD = SdkField
            .<AnomalyDetectorMissingDataAction> builder(MarshallingType.SDK_POJO).memberName("missingDataAction")
            .getter(getter(CreateAnomalyDetectorRequest::missingDataAction)).setter(setter(Builder::missingDataAction))
            .constructor(AnomalyDetectorMissingDataAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingDataAction").build()).build();

    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField
            .<AnomalyDetectorConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateAnomalyDetectorRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AnomalyDetectorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labels")
            .getter(getter(CreateAnomalyDetectorRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAnomalyDetectorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAnomalyDetectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            ALIAS_FIELD, EVALUATION_INTERVAL_IN_SECONDS_FIELD, MISSING_DATA_ACTION_FIELD, CONFIGURATION_FIELD, LABELS_FIELD,
            CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String alias;

    private final Integer evaluationIntervalInSeconds;

    private final AnomalyDetectorMissingDataAction missingDataAction;

    private final AnomalyDetectorConfiguration configuration;

    private final Map<String, String> labels;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.alias = builder.alias;
        this.evaluationIntervalInSeconds = builder.evaluationIntervalInSeconds;
        this.missingDataAction = builder.missingDataAction;
        this.configuration = builder.configuration;
        this.labels = builder.labels;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the workspace where the anomaly detector will be created.
     * </p>
     * 
     * @return The identifier of the workspace where the anomaly detector will be created.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * A user-friendly name for the anomaly detector.
     * </p>
     * 
     * @return A user-friendly name for the anomaly detector.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The frequency, in seconds, at which the anomaly detector evaluates metrics. The default value is 60 seconds.
     * </p>
     * 
     * @return The frequency, in seconds, at which the anomaly detector evaluates metrics. The default value is 60
     *         seconds.
     */
    public final Integer evaluationIntervalInSeconds() {
        return evaluationIntervalInSeconds;
    }

    /**
     * <p>
     * Specifies the action to take when data is missing during evaluation.
     * </p>
     * 
     * @return Specifies the action to take when data is missing during evaluation.
     */
    public final AnomalyDetectorMissingDataAction missingDataAction() {
        return missingDataAction;
    }

    /**
     * <p>
     * The algorithm configuration for the anomaly detector.
     * </p>
     * 
     * @return The algorithm configuration for the anomaly detector.
     */
    public final AnomalyDetectorConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon Managed Service for Prometheus metric labels to associate with the anomaly detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return The Amazon Managed Service for Prometheus metric labels to associate with the anomaly detector.
     */
    public final Map<String, String> labels() {
        return labels;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the anomaly detector to assist with categorization and organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata to apply to the anomaly detector to assist with categorization and organization.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(missingDataAction());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyDetectorRequest)) {
            return false;
        }
        CreateAnomalyDetectorRequest other = (CreateAnomalyDetectorRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(evaluationIntervalInSeconds(), other.evaluationIntervalInSeconds())
                && Objects.equals(missingDataAction(), other.missingDataAction())
                && Objects.equals(configuration(), other.configuration()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalyDetectorRequest").add("WorkspaceId", workspaceId()).add("Alias", alias())
                .add("EvaluationIntervalInSeconds", evaluationIntervalInSeconds()).add("MissingDataAction", missingDataAction())
                .add("Configuration", configuration()).add("Labels", hasLabels() ? labels() : null)
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "evaluationIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(evaluationIntervalInSeconds()));
        case "missingDataAction":
            return Optional.ofNullable(clazz.cast(missingDataAction()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("evaluationIntervalInSeconds", EVALUATION_INTERVAL_IN_SECONDS_FIELD);
        map.put("missingDataAction", MISSING_DATA_ACTION_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
        /**
         * <p>
         * The identifier of the workspace where the anomaly detector will be created.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the workspace where the anomaly detector will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A user-friendly name for the anomaly detector.
         * </p>
         * 
         * @param alias
         *        A user-friendly name for the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The frequency, in seconds, at which the anomaly detector evaluates metrics. The default value is 60 seconds.
         * </p>
         * 
         * @param evaluationIntervalInSeconds
         *        The frequency, in seconds, at which the anomaly detector evaluates metrics. The default value is 60
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationIntervalInSeconds(Integer evaluationIntervalInSeconds);

        /**
         * <p>
         * Specifies the action to take when data is missing during evaluation.
         * </p>
         * 
         * @param missingDataAction
         *        Specifies the action to take when data is missing during evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingDataAction(AnomalyDetectorMissingDataAction missingDataAction);

        /**
         * <p>
         * Specifies the action to take when data is missing during evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorMissingDataAction.Builder}
         * avoiding the need to create one manually via {@link AnomalyDetectorMissingDataAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorMissingDataAction.Builder#build()} is called
         * immediately and its result is passed to {@link #missingDataAction(AnomalyDetectorMissingDataAction)}.
         * 
         * @param missingDataAction
         *        a consumer that will call methods on {@link AnomalyDetectorMissingDataAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingDataAction(AnomalyDetectorMissingDataAction)
         */
        default Builder missingDataAction(Consumer<AnomalyDetectorMissingDataAction.Builder> missingDataAction) {
            return missingDataAction(AnomalyDetectorMissingDataAction.builder().applyMutation(missingDataAction).build());
        }

        /**
         * <p>
         * The algorithm configuration for the anomaly detector.
         * </p>
         * 
         * @param configuration
         *        The algorithm configuration for the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AnomalyDetectorConfiguration configuration);

        /**
         * <p>
         * The algorithm configuration for the anomaly detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorConfiguration.Builder}
         * avoiding the need to create one manually via {@link AnomalyDetectorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(AnomalyDetectorConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AnomalyDetectorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AnomalyDetectorConfiguration)
         */
        default Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return configuration(AnomalyDetectorConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The Amazon Managed Service for Prometheus metric labels to associate with the anomaly detector.
         * </p>
         * 
         * @param labels
         *        The Amazon Managed Service for Prometheus metric labels to associate with the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The metadata to apply to the anomaly detector to assist with categorization and organization.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the anomaly detector to assist with categorization and organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String alias;

        private Integer evaluationIntervalInSeconds;

        private AnomalyDetectorMissingDataAction missingDataAction;

        private AnomalyDetectorConfiguration configuration;

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyDetectorRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            alias(model.alias);
            evaluationIntervalInSeconds(model.evaluationIntervalInSeconds);
            missingDataAction(model.missingDataAction);
            configuration(model.configuration);
            labels(model.labels);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Integer getEvaluationIntervalInSeconds() {
            return evaluationIntervalInSeconds;
        }

        public final void setEvaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
        }

        @Override
        public final Builder evaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
            return this;
        }

        public final AnomalyDetectorMissingDataAction.Builder getMissingDataAction() {
            return missingDataAction != null ? missingDataAction.toBuilder() : null;
        }

        public final void setMissingDataAction(AnomalyDetectorMissingDataAction.BuilderImpl missingDataAction) {
            this.missingDataAction = missingDataAction != null ? missingDataAction.build() : null;
        }

        @Override
        public final Builder missingDataAction(AnomalyDetectorMissingDataAction missingDataAction) {
            this.missingDataAction = missingDataAction;
            return this;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = CreateAnomalyDetectorRequestLabelsMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = CreateAnomalyDetectorRequestLabelsMapCopier.copy(labels);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalyDetectorRequest build() {
            return new CreateAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
