/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an anomaly detector for list operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyDetectorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyDetectorSummary.Builder, AnomalyDetectorSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AnomalyDetectorSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorId").getter(getter(AnomalyDetectorSummary::anomalyDetectorId))
            .setter(setter(Builder::anomalyDetectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(AnomalyDetectorSummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<AnomalyDetectorStatus> STATUS_FIELD = SdkField
            .<AnomalyDetectorStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(AnomalyDetectorSummary::status)).setter(setter(Builder::status))
            .constructor(AnomalyDetectorStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AnomalyDetectorSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(AnomalyDetectorSummary::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AnomalyDetectorSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ANOMALY_DETECTOR_ID_FIELD, ALIAS_FIELD, STATUS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String anomalyDetectorId;

    private final String alias;

    private final AnomalyDetectorStatus status;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final Map<String, String> tags;

    private AnomalyDetectorSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.anomalyDetectorId = builder.anomalyDetectorId;
        this.alias = builder.alias;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the anomaly detector.
     * </p>
     * 
     * @return The unique identifier of the anomaly detector.
     */
    public final String anomalyDetectorId() {
        return anomalyDetectorId;
    }

    /**
     * <p>
     * The user-friendly name of the anomaly detector.
     * </p>
     * 
     * @return The user-friendly name of the anomaly detector.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The current status of the anomaly detector.
     * </p>
     * 
     * @return The current status of the anomaly detector.
     */
    public final AnomalyDetectorStatus status() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the anomaly detector was created.
     * </p>
     * 
     * @return The timestamp when the anomaly detector was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the anomaly detector was last modified.
     * </p>
     * 
     * @return The timestamp when the anomaly detector was last modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags applied to the anomaly detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags applied to the anomaly detector.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorSummary)) {
            return false;
        }
        AnomalyDetectorSummary other = (AnomalyDetectorSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(anomalyDetectorId(), other.anomalyDetectorId())
                && Objects.equals(alias(), other.alias()) && Objects.equals(status(), other.status())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyDetectorSummary").add("Arn", arn()).add("AnomalyDetectorId", anomalyDetectorId())
                .add("Alias", alias()).add("Status", status()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "anomalyDetectorId":
            return Optional.ofNullable(clazz.cast(anomalyDetectorId()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("anomalyDetectorId", ANOMALY_DETECTOR_ID_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorSummary, T> g) {
        return obj -> g.apply((AnomalyDetectorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyDetectorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorId
         *        The unique identifier of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorId(String anomalyDetectorId);

        /**
         * <p>
         * The user-friendly name of the anomaly detector.
         * </p>
         * 
         * @param alias
         *        The user-friendly name of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The current status of the anomaly detector.
         * </p>
         * 
         * @param status
         *        The current status of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AnomalyDetectorStatus status);

        /**
         * <p>
         * The current status of the anomaly detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorStatus.Builder} avoiding
         * the need to create one manually via {@link AnomalyDetectorStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(AnomalyDetectorStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AnomalyDetectorStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AnomalyDetectorStatus)
         */
        default Builder status(Consumer<AnomalyDetectorStatus.Builder> status) {
            return status(AnomalyDetectorStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The timestamp when the anomaly detector was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the anomaly detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the anomaly detector was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        The timestamp when the anomaly detector was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The tags applied to the anomaly detector.
         * </p>
         * 
         * @param tags
         *        The tags applied to the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String anomalyDetectorId;

        private String alias;

        private AnomalyDetectorStatus status;

        private Instant createdAt;

        private Instant modifiedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorSummary model) {
            arn(model.arn);
            anomalyDetectorId(model.anomalyDetectorId);
            alias(model.alias);
            status(model.status);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnomalyDetectorId() {
            return anomalyDetectorId;
        }

        public final void setAnomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
        }

        @Override
        public final Builder anomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final AnomalyDetectorStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AnomalyDetectorStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AnomalyDetectorStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public AnomalyDetectorSummary build() {
            return new AnomalyDetectorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
