/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.CloudWatchLogDestination;
import software.amazon.awssdk.services.amp.model.LoggingFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingDestination> {
    private static final SdkField<CloudWatchLogDestination> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(LoggingDestination.getter(LoggingDestination::cloudWatchLogs)).setter(LoggingDestination.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<LoggingFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filters").getter(LoggingDestination.getter(LoggingDestination::filters)).setter(LoggingDestination.setter(Builder::filters)).constructor(LoggingFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoggingDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogDestination cloudWatchLogs;
    private final LoggingFilter filters;

    private LoggingDestination(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.filters = builder.filters;
    }

    public final CloudWatchLogDestination cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final LoggingFilter filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingDestination)) {
            return false;
        }
        LoggingDestination other = (LoggingDestination)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingDestination").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Filters", (Object)this.filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingDestination, T> g) {
        return obj -> g.apply((LoggingDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogDestination cloudWatchLogs;
        private LoggingFilter filters;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingDestination model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.filters(model.filters);
        }

        public final CloudWatchLogDestination.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final LoggingFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(LoggingFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(LoggingFilter filters) {
            this.filters = filters;
            return this;
        }

        public LoggingDestination build() {
            return new LoggingDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingDestination> {
        public Builder cloudWatchLogs(CloudWatchLogDestination var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogDestination.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogDestination)((CloudWatchLogDestination.Builder)CloudWatchLogDestination.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder filters(LoggingFilter var1);

        default public Builder filters(Consumer<LoggingFilter.Builder> filters) {
            return this.filters((LoggingFilter)((LoggingFilter.Builder)LoggingFilter.builder().applyMutation(filters)).build());
        }
    }
}

